<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceWeatherResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（お天気Webサービス用）
 *
 * 詳細は、Weather Hacks（気象データ配信サービス）参照
 *   http://weather.livedoor.com/weather_hacks/
 * お天気Webサービス
 *   http://weather.livedoor.com/weather_hacks/webservice.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceWeatherResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceWeatherResponse extends SyL_WebServiceLivedoor_comResponse
{
    /**
     * 天気データ配列
     *
     * @access private
     * @var array
     */
    var $result = array();
    /**
     * ピンポイント天気情報リンク
     *
     * @access private
     * @var array
     */
    var $pinpoints = array();
    /**
     * 著作権情報
     *
     * @access private
     * @var array
     */
    var $copyright = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/lwws':
            if (isset($attribute['version'])) {
                $this->result['version'] = $attribute['version'];
            }
            break;
        // 予報を発表した地域
        case '/lwws/location':
            if (isset($attribute['area'])) {
                $this->result['area'] = $attribute['area'];
            }
            if (isset($attribute['pref'])) {
                $this->result['pref'] = $attribute['pref'];
            }
            if (isset($attribute['city'])) {
                $this->result['city'] = $attribute['city'];
            }
            break;
        // タイトル・見出し
        case '/lwws/title': $this->result['title'] = $text; break;
        // リクエストされたデータの地域に該当するlivedoor 天気情報のURL
        case '/lwws/link': $this->result['link'] = $text; break;
        // 予報日
        case '/lwws/forecastday': $this->result['forecastday'] = $text; break;
        // 曜日
        case '/lwws/day': $this->result['day'] = $text; break;
        // 予報日
        case '/lwws/forecastdate': $this->result['forecastdate'] = $text; break;
        // 予報の発表日時
        case '/lwws/publictime': $this->result['publictime'] = $text; break;
        // 天気（晴れ、曇り、雨など）
        case '/lwws/telop': $this->result['telop'] = $text; break;
        // 天気概況文
        case '/lwws/description': $this->result['description'] = $text; break;
        // 天気画像
        case '/lwws/image': $this->result['image'] = array(); break;
        // 天気（晴れ、曇り、雨など）
        case '/lwws/image/title': $this->result['image']['title'] = $text; break;
        // リクエストされたデータの地域に該当するlivedoor 天気情報のURL
        case '/lwws/image/link': $this->result['image']['link'] = $text; break;
        // 天気アイコンのURL
        case '/lwws/image/url': $this->result['image']['url'] = $text; break;
        // 天気アイコンの幅
        case '/lwws/image/width': $this->result['image']['width'] = $text; break;
        // 天気アイコンの高さ
        case '/lwws/image/height': $this->result['image']['height'] = $text; break;
        // 気温
        case '/lwws/temperature':     $this->result['temperature'] = array(); break;
        case '/lwws/temperature/max': $this->result['temperature']['max'] = array(); break;
        case '/lwws/temperature/min': $this->result['temperature']['min'] = array(); break;
        // 最高気温
        case '/lwws/temperature/max/celsius':    $this->result['temperature']['max']['celsius']['C'] = $text; break;
        case '/lwws/temperature/max/fahrenheit': $this->result['temperature']['max']['celsius']['F'] = $text; break;
        // 最低気温
        case '/lwws/temperature/min/celsius':    $this->result['temperature']['min']['celsius']['C'] = $text; break;
        case '/lwws/temperature/min/fahrenheit': $this->result['temperature']['min']['celsius']['F'] = $text; break;

        // ピンポイント天気予報
        case '/lwws/pinpoint/location': $i++; break;
        // 市区町村名
        case '/lwws/pinpoint/location/title': $this->pinpoints[$i]['title'] = $text; break;
        // 対応するlivedoor 天気情報のURL
        case '/lwws/pinpoint/location/link': $this->pinpoints[$i]['link'] = $text; break;
        // ピンポイント天気予報の発表時間
        case '/lwws/pinpoint/location/publictime': $this->pinpoints[$i]['publictime'] = $text; break;

        // コピーライトの文言
        case '/lwws/copyright/title': $this->copyright['title'] = $text; break;
        // livedoor 天気情報のURL
        case '/lwws/copyright/link': $this->copyright['link'] = $text; break;
        // livedoor 天気情報へのURL、アイコンなど
        case '/lwws/copyright/image': $this->copyright['image'] = array(); break;
        case '/lwws/copyright/image/title':  $this->copyright['image']['title']  = $text; break;
        case '/lwws/copyright/image/link':   $this->copyright['image']['link']   = $text; break;
        case '/lwws/copyright/image/url':    $this->copyright['image']['url']    = $text; break;
        case '/lwws/copyright/image/width':  $this->copyright['image']['width']  = $text; break;
        case '/lwws/copyright/image/height': $this->copyright['image']['height'] = $text; break;
        // livedoor 天気情報で使用している気象データの配信元
        case '/lwws/copyright/provider': $this->copyright['provider'][] = $text; break;

        }
    }

    /**
     * 天気データを取得する
     *
     * @access public
     * @param string キー名
     * @return mixed 天気データ
     */
    function getResult($name=null)
    {
        if ($name !== null) {
            return isset($this->result[$name]) ? $this->result[$name] : null;
        } else {
            return $this->result;
        }
    }

    /**
     * ピンポイント天気情報リンク情報を取得する
     *
     * @access public
     * @return array ピンポイント天気情報リンク情報
     */
    function getPinpoints()
    {
        return $this->pinpoints;
    }

    /**
     * 著作権情報を取得する
     *
     * @access public
     * @param string キー名
     * @return mixed 著作権情報
     */
    function getCopyright($name=null)
    {
        if ($name !== null) {
            return isset($this->copyright[$name]) ? $this->copyright[$name] : null;
        } else {
            return $this->copyright;
        }
    }
}
