<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAdDynamicTravelRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天ダイナミックアドAPI　トラベル用）
 */
require_once 'SyL_WebServiceAdDynamicTravelResponse.php';

/**
 * WEBサービスクラス（楽天 - 楽天ダイナミックアドAPI　トラベル用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天ダイナミックアドAPI　トラベル
 *   http://webservice.rakuten.co.jp/api/dynamicad_travel/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAdDynamicTravelRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceAdDynamicTravelRequest extends SyL_WebServiceRakuten_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'dynamic.rakuten.co.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/rcm/1.0/t/rest';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceAdDynamicTravelResponse';

    /**
     * バージョンをセットする
     *
     * @access public
     * @param string バージョン
     */
    function setUrl($url)
    {
        parent::set('url', $url);
    }

    /**
     * キャリアをセットする
     *
     * @access public
     * @param int キャリア
     */
    function setCarrier($carrier)
    {
        switch ((string)$carrier) {
        case '0':
        case '1':
            parent::set('carrier', $carrier);
            break;
        default:
            trigger_error("[SyL error] Invalid `carrier' property ({$carrier}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
