<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelKeywordHotelSearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天トラベル施設検索API 用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天トラベル施設検索API  
 *   http://webservice.rakuten.co.jp/api/simplehotelsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelKeywordHotelSearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceTravelKeywordHotelSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * レコード件数
     *
     * @access private
     * @var int
     */
    var $record_count = 0;
    /**
     * 施設情報
     *
     * @access private
     * @var array
     */
    var $hotel_simples = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // レコード件数（宿泊施設）
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/recordCount': $this->record_count = $text; break;
        
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple': $i++; break;
        // 施設番号
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/hotelNo': $this->hotel_simples[$i]['hotelNo'] = $text; break;
        // 施設名称
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/hotelName': $this->hotel_simples[$i]['hotelName'] = $text; break;
        // 要約情報（地区）
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/areaSum': $this->hotel_simples[$i]['areaSum'] = $text; break;
        // 要約情報（特色）
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/hotelSpecialSum': $this->hotel_simples[$i]['hotelSpecialSum'] = $text; break;
        // 中区分コード
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/middleClassCode': $this->hotel_simples[$i]['middleClassCode'] = $text; break;
        // 小区分コード
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/smallClassCode': $this->hotel_simples[$i]['smallClassCode'] = $text; break;
        // 施設情報ページURL
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/hotelInformationUrl': $this->hotel_simples[$i]['hotelInformationUrl'] = $text; break;
        // 施設情報ページアフィリエイトURL
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/hotelAffiliateUrl': $this->hotel_simples[$i]['hotelAffiliateUrl'] = $text; break;
        // ★の数（レビュー平均）
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/reviewAverage': $this->hotel_simples[$i]['reviewAverage'] = $text; break;
        // 投稿件数
        case '/Response/Body/keywordHotelSearch:KeywordHotelSearch/hotelSimple/reviewCount': $this->hotel_simples[$i]['reviewCount'] = $text; break;

        // 上記以外
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * レコード件数を取得する
     *
     * @access public
     * @return int レコード件数
     */
    function getRecordCount()
    {
        return $this->record_count;
    }

    /**
     * 施設情報を取得する
     *
     * @access public
     * @return array 施設情報
     */
    function getHotelSimples()
    {
        return $this->hotel_simples;
    }
}
