<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceYahoo_co_jp.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスリクエストクラス（Yahoo! Japan）
 */
require_once dirname(__FILE__) . '/Yahoo_co_jp/SyL_WebServiceYahoo_co_jpRequest.php';
/**
 * WEBサービスレスポンスクラス（Yahoo! Japan）
 */
require_once dirname(__FILE__) . '/Yahoo_co_jp/SyL_WebServiceYahoo_co_jpResponse.php';

/**
 * WEBサービスクラス（Yahoo! Japan用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceYahoo_co_jp.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceYahoo_co_jp extends SyL_WebService
{
    // -----------------------------------------------------
    // Yahoo!検索
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（ウェブ検索用）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（ウェブ検索用）
     */
    function &createSearchWebRequest()
    {
        $class_name = 'SyL_WebServiceSearchWebRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Search/Web/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（画像検索用）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（画像検索用）
     */
    function &createSearchImageRequest()
    {
        $class_name = 'SyL_WebServiceSearchImageRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Search/Image/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（動画検索用）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（動画検索用）
     */
    function &createSearchVideoRequest()
    {
        $class_name = 'SyL_WebServiceSearchVideoRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Search/Video/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（関連検索用）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（関連検索用）
     */
    function &createSearchWebunitRequest()
    {
        $class_name = 'SyL_WebServiceSearchWebunitRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Search/Webunit/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!カテゴリ
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（ディレクトリツリー用）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（ディレクトリツリー用）
     */
    function &createCategoryBrowseRequest()
    {
        $class_name = 'SyL_WebServiceCategoryBrowseRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Category/Browse/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（ディレクトリサーチ用）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（ディレクトリサーチ用）
     */
    function &createCategorySearchRequest()
    {
        $class_name = 'SyL_WebServiceCategorySearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Category/Search/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!オークション
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（オークション - カテゴリ情報用）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（オークション - カテゴリ情報用）
     */
    function &createAuctionCategoryTreeRequest()
    {
        $class_name = 'SyL_WebServiceAuctionCategoryTreeRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Auction/CategoryTree/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（オークション - 商品リスト用）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（オークション - 商品リスト用）
     */
    function &createAuctionCategoryLeafRequest()
    {
        $class_name = 'SyL_WebServiceAuctionCategoryLeafRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Auction/CategoryLeaf/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（オークション - 出品リスト用）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（オークション - 出品リスト用）
     */
    function &createAuctionSellingListRequest()
    {
        $class_name = 'SyL_WebServiceAuctionSellingListRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Auction/SellingList/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（オークション - 検索用）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（オークション - 検索用）
     */
    function &createAuctionSearchRequest()
    {
        $class_name = 'SyL_WebServiceAuctionSearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Auction/Search/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（オークション - 商品詳細用）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（オークション - 商品詳細用）
     */
    function &createAuctionAuctionItemRequest()
    {
        $class_name = 'SyL_WebServiceAuctionAuctionItemRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Auction/AuctionItem/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!ミュージック
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（サウンドステーション番組リスト用）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（サウンドステーション番組リスト用）
     */
    function &createMusicStationRequest()
    {
        $class_name = 'SyL_WebServiceMusicStationRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Music/Station/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!地図情報
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（地図情報 - ローカルサーチAPI）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（地図情報 - ローカルサーチAPI）
     */
    function &createMapLocalSearchRequest()
    {
        $class_name = 'SyL_WebServiceMapLocalSearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Map/LocalSearch/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // テキスト解析
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（日本語形態素解析Webサービス）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（日本語形態素解析Webサービス）
     */
    function &createJlpMAServiceRequest()
    {
        $class_name = 'SyL_WebServiceJlpMAServiceRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Jlp/MAService/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（かな漢字変換Webサービス）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（かな漢字変換Webサービス）
     */
    function &createJlpJIMServiceRequest()
    {
        $class_name = 'SyL_WebServiceJlpJIMServiceRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Jlp/JIMService/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（校正支援Webサービス）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（校正支援Webサービス）
     */
    function &createJlpKouseiServiceRequest()
    {
        $class_name = 'SyL_WebServiceJlpKouseiServiceRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Jlp/KouseiService/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（ルビ振りWebサービス）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（ルビ振りWebサービス）
     */
    function &createJlpFuriganaServiceRequest()
    {
        $class_name = 'SyL_WebServiceJlpFuriganaServiceRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Jlp/FuriganaService/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（日本語係り受け解析Webサービス）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（日本語係り受け解析Webサービス）
     */
    function &createJlpDAServiceRequest()
    {
        $class_name = 'SyL_WebServiceJlpDAServiceRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Jlp/DAService/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（指定形容詞係り先検索Webサービス）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（指定形容詞係り先検索Webサービス）
     */
    function &createJlpDAServiceSearchRequest()
    {
        $class_name = 'SyL_WebServiceJlpDAServiceSearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Jlp/DAServiceSearch/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!家電ナビ
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（製品検索）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（製品検索）
     */
    function &createKadenProductSearchRequest()
    {
        $class_name = 'SyL_WebServiceKadenProductSearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Kaden/ProductSearch/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（製品情報）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（製品情報）
     */
    function &createKadenProductItemRequest()
    {
        $class_name = 'SyL_WebServiceKadenProductItemRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Kaden/ProductItem/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!ニュース
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（ニュース - トピックスAPI）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（ニュース - トピックスAPI）
     */
    function &createNewsTopicsRequest()
    {
        $class_name = 'SyL_WebServiceNewsTopicsRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/News/Topics/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!みんなの検定
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（みんなの検定 検定リストWebサービス）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（みんなの検定 検定リストWebサービス）
     */
    function &createMinnaCertCertListRequest()
    {
        $class_name = 'SyL_WebServiceMinnaCertCertListRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/MinnaCert/CertList/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（みんなの検定 検定詳細Webサービス）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（みんなの検定 検定詳細Webサービス）
     */
    function &createMinnaCertCertDetailRequest()
    {
        $class_name = 'SyL_WebServiceMinnaCertCertDetailRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/MinnaCert/CertDetail/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（みんなの検定 検定受験Webサービス）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（みんなの検定 検定受験Webサービス）
     */
    function &createMinnaCertCertExamRequest()
    {
        $class_name = 'SyL_WebServiceMinnaCertCertExamRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/MinnaCert/CertExam/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!知恵袋
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（Yahoo!知恵袋: 質問検索Webサービス）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（Yahoo!知恵袋: 質問検索Webサービス）
     */
    function &createChiebukuroQuestionSearchRequest()
    {
        $class_name = 'SyL_WebServiceChiebukuroQuestionSearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Chiebukuro/QuestionSearch/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（Yahoo!知恵袋: カテゴリツリー）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（Yahoo!知恵袋: カテゴリツリー）
     */
    function &createChiebukuroCategoryTreeRequest()
    {
        $class_name = 'SyL_WebServiceChiebukuroCategoryTreeRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Chiebukuro/CategoryTree/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!ショッピング
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（商品検索）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（商品検索）
     */
    function &createShoppingItemsearchRequest()
    {
        $class_name = 'SyL_WebServiceShoppingItemsearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Shopping/Itemsearch/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（カテゴリランキング）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（カテゴリランキング）
     */
    function &createShoppingCategoryrankingRequest()
    {
        $class_name = 'SyL_WebServiceShoppingCategoryrankingRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Shopping/Categoryranking/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（カテゴリID取得）
     * 
     * @access public
     * @return object WEBサービスリクエストオブジェクト（カテゴリID取得）
     */
    function &createShoppingCategorysearchRequest()
    {
        $class_name = 'SyL_WebServiceShoppingCategorysearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Shopping/Categorysearch/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }
}
