<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionAuctionItemResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - オークション - 商品詳細用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * オークション - 商品詳細
 *   http://developer.yahoo.co.jp/auctions/rest/auctionitem/V1/auctionitem.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionAuctionItemResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceAuctionAuctionItemResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 商品（オークション）情報
     *
     * @access private
     * @var array
     */
    var $item = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 商品（オークション）のID
        case '/AuctionItem/auctionID': $this->item['auctionID'] = $text; break;
        // カテゴリのID
        case '/AuctionItem/categoryID': $this->item['categoryID'] = $text; break;
        // 最上位カテゴリからのパス
        case '/AuctionItem/categoryPath': $this->item['categoryPath'] = $text; break;
        // 商品（オークション）のタイトル
        case '/AuctionItem/title': $this->item['title'] = $text; break;
        // 商品（オークション）のURL
        case '/AuctionItem/url': $this->item['url'] = $text; break;
        // 出品者に関する情報
        case '/AuctionItem/seller': $this->item['seller'] = array(); break;
        // 出品者のYahoo! JAPAN ID
        case '/AuctionItem/seller/id': $this->item['seller']['id'] = $text; break;
        // 出品地域
        case '/AuctionItem/seller/location': $this->item['seller']['location'] = $text; break;
        // 出品リストを取得するリクエストURL
        case '/AuctionItem/seller/itemlist': $this->item['seller']['itemlist'] = $text; break;
        // 出品者の評価のページのURL
        case '/AuctionItem/seller/rating': $this->item['seller']['rating'] = $text; break;
        // 画像（サムネイル）のURL
        case '/AuctionItem/img': $this->item['img'] = $text; break;
        // 画像1のURL
        case '/AuctionItem/image1':
            $this->item['image1'] = array();
            $this->item['image1']['width']  = isset($attribute['width'])  ? $attribute['width']  : null;
            $this->item['image1']['height'] = isset($attribute['height']) ? $attribute['height'] : null;
            $this->item['image1']['url']    = $text;
            break;
        // 画像2のURL
        case '/AuctionItem/image2':
            $this->item['image2'] = array();
            $this->item['image2']['width']  = isset($attribute['width'])  ? $attribute['width']  : null;
            $this->item['image2']['height'] = isset($attribute['height']) ? $attribute['height'] : null;
            $this->item['image2']['url']    = $text;
            break;
        // 画像3のURL
        case '/AuctionItem/image3':
            $this->item['image3'] = array();
            $this->item['image3']['width']  = isset($attribute['width'])  ? $attribute['width']  : null;
            $this->item['image3']['height'] = isset($attribute['height']) ? $attribute['height'] : null;
            $this->item['image3']['url']    = $text;
            break;

        // 開始価格
        case '/AuctionItem/initprice': $this->item['initprice'] = $text; break;
        // 現在価格
        case '/AuctionItem/price': $this->item['price'] = $text; break;
        // 商品の数量
        case '/AuctionItem/quantity': $this->item['quantity'] = $text; break;
        // 現在の入札数
        case '/AuctionItem/bids': $this->item['bids'] = $text; break;
        // オークションの開始日時
        case '/AuctionItem/starttime': $this->item['starttime'] = $text; break;
        // オークションの終了日時
        case '/AuctionItem/endtime': $this->item['endtime'] = $text; break;
        // オークションの残り時間
        case '/AuctionItem/timeleft': $this->item['timeleft'] = $text; break;
        // 希望落札価格
        case '/AuctionItem/bidorbuy': $this->item['bidorbuy'] = $text; break;
        // 最低落札価格の有無
        case '/AuctionItem/reserved': $this->item['reserved'] = $text; break;
        // 商品（オークション）のオプション設定
        case '/AuctionItem/option': $this->item['option'] = array(); break;
        // 商品（オークション）のオプション設定: 「store」アイコンのURL
        case '/AuctionItem/option/store': $this->item['option']['store'] = $text; break;
        // 商品（オークション）のオプション設定: 「鑑定済み」アイコンのURL
        case '/AuctionItem/option/check': $this->item['option']['check'] = $text; break;
        // 商品（オークション）のオプション設定: 「公売」アイコンのURL
        case '/AuctionItem/option/public': $this->item['option']['public'] = $text; break;
        // 商品（オークション）のオプション設定: 「送料無料」アイコンのURL
        case '/AuctionItem/option/freeshipping': $this->item['option']['freeshipping'] = $text; break;
        // 商品（オークション）のオプション設定: 「受け取り後決済サービス」アイコンのURL
        case '/AuctionItem/option/escrow': $this->item['option']['escrow'] = $text; break;
        // 商品（オークション）のオプション設定: 「贈答品」アイコンのURL
        case '/AuctionItem/option/wrappingicon': $this->item['option']['wrappingicon'] = $text; break;
        // 商品（オークション）のオプション設定: 「即買」アイコンのURL
        case '/AuctionItem/option/buynow': $this->item['option']['buynow'] = $text; break;
        // 商品（オークション）のオプション設定: 「Yahoo!かんたん決済」アイコンのURL
        case '/AuctionItem/option/easypayment': $this->item['option']['easypayment'] = $text; break;
        // 商品（オークション）のオプション設定: 「特大画像」アイコンのURL
        case '/AuctionItem/option/largeimg': $this->item['option']['largeimg'] = $text; break;
        // 商品（オークション）のオプション設定: 「目立ち」アイコンのURL
        case '/AuctionItem/option/gift_icon': $this->item['option']['gift_icon'] = $text; break;
        // 商品説明
        case '/AuctionItem/description': $this->item['description'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 商品（オークション）情報を取得
     *
     * @access public
     * @return mixed 商品（オークション）情報
     */
    function getItem($name=null)
    {
        if ($name !== null) {
            return isset($this->item[$name]) ? $this->item[$name] : null;
        } else {
            return $this->item;
        }
    }
}
