<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionSearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - オークション - 検索用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * オークション - 検索
 *   http://developer.yahoo.co.jp/auctions/rest/search/V1/search.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionSearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceAuctionSearchResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 条件に一致した商品（オークション）の総数 
     *
     * @access private
     * @var int
     */
    var $total_auctions = null;
    /**
     * 件に一致したページ総数
     *
     * @access private
     * @var int
     */
    var $total_page = null;
    /**
     * 現在のページ番号
     *
     * @access private
     * @var string
     */
    var $cur_page = null;
    /**
     * 商品（オークション）情報
     *
     * @access private
     * @var array
     */
    var $items = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $item_i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/AuctionSearchResult':
            if (isset($attribute['totalAuctions'])) {
                $this->total_auctions = $attribute['totalAuctions'];
            }
            if (isset($attribute['totalPage'])) {
                $this->total_page = $attribute['totalPage'];
            }
            if (isset($attribute['curPage'])) {
                $this->cur_page = $attribute['curPage'];
            }
            break;

        // 商品（オークション）情報
        case '/AuctionSearchResult/item': $item_i++; break;
        // 商品（オークション）のID
        case '/AuctionSearchResult/item/auctionID': $this->items[$item_i]['auctionID'] = $text; break;
        // 商品（オークション）のタイトル
        case '/AuctionSearchResult/item/title': $this->items[$item_i]['title'] = $text; break;
        // 出品者に関する情報
        case '/AuctionSearchResult/item/seller': $this->items[$item_i]['seller'] = array(); break;
        // 出品者のYahoo! JAPAN ID
        case '/AuctionSearchResult/item/seller/id': $this->items[$item_i]['seller']['id'] = $text; break;
        // 出品リストを取得するリクエストURL
        case '/AuctionSearchResult/item/seller/itemlist': $this->items[$item_i]['seller']['itemlist'] = $text; break;
        // 出品者の評価のページのURL
        case '/AuctionSearchResult/item/seller/rating': $this->items[$item_i]['seller']['rating'] = $text; break;
        // 商品詳細（オークション）ページのURL
        case '/AuctionSearchResult/item/url': $this->items[$item_i]['url'] = $text; break;
        // 画像（サムネイル）のURL
        case '/AuctionSearchResult/item/img': $this->items[$item_i]['img'] = $text; break;
        // 現在価格
        case '/AuctionSearchResult/item/price': $this->items[$item_i]['price'] = $text; break;
        // 現在の入札数
        case '/AuctionSearchResult/item/bids': $this->items[$item_i]['bids'] = $text; break;
        // オークションの終了日時
        case '/AuctionSearchResult/item/endtime': $this->items[$item_i]['endtime'] = $text; break;
        // 希望落札価格
        case '/AuctionSearchResult/item/bidorbuy': $this->items[$item_i]['bidorbuy'] = $text; break;
        // 最低落札価格の有無
        case '/AuctionSearchResult/item/reserved': $this->items[$item_i]['reserved'] = $text; break;
        // 商品（オークション）のオプション設定
        case '/AuctionSearchResult/item/option': $this->items[$item_i]['option'] = array(); break;
        // 商品（オークション）のオプション設定: 「new」アイコンのURL
        case '/AuctionSearchResult/item/option/new': $this->items[$item_i]['option']['new'] = $text; break;
        // 商品（オークション）のオプション設定: 「store」アイコンのURL
        case '/AuctionSearchResult/item/option/store': $this->items[$item_i]['option']['store'] = $text; break;
        // 商品（オークション）のオプション設定: 「鑑定済み」アイコンのURL
        case '/AuctionSearchResult/item/option/check': $this->items[$item_i]['option']['check'] = $text; break;
        // 商品（オークション）のオプション設定: 「公売」アイコンのURL
        case '/AuctionSearchResult/item/option/public': $this->items[$item_i]['option']['public'] = $text; break;
        // 商品（オークション）のオプション設定: 「送料無料」アイコンのURL
        case '/AuctionSearchResult/item/option/freeshipping': $this->items[$item_i]['option']['freeshipping'] = $text; break;
        // 商品（オークション）のオプション設定: 「受け取り後決済サービス」アイコンのURL
        case '/AuctionSearchResult/item/option/escrow': $this->items[$item_i]['option']['escrow'] = $text; break;
        // 商品（オークション）のオプション設定: 「贈答品」アイコンのURL
        case '/AuctionSearchResult/item/option/wrappingicon': $this->items[$item_i]['option']['wrappingicon'] = $text; break;
        // 商品（オークション）のオプション設定: 「即買」アイコンのURL
        case '/AuctionSearchResult/item/option/buynow': $this->items[$item_i]['option']['buynow'] = $text; break;
        // 商品（オークション）のオプション設定: 「Yahoo!かんたん決済」アイコンのURL
        case '/AuctionSearchResult/item/option/easypayment': $this->items[$item_i]['option']['easypayment'] = $text; break;
        // 商品（オークション）のオプション設定: 「特大画像」アイコンのURL
        case '/AuctionSearchResult/item/option/largeimg': $this->items[$item_i]['option']['largeimg'] = $text; break;
        // 商品（オークション）のオプション設定: 「目立ち」アイコンのURL
        case '/AuctionSearchResult/item/option/gift_icon': $this->items[$item_i]['option']['gift_icon'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 条件に一致した商品（オークション）の総数を取得
     *
     * @access public
     * @return int 条件に一致した商品（オークション）の総数
     */
    function getTotalAuctions()
    {
        return $this->total_auctions;
    }

    /**
     * 条件に一致したページ総数を取得
     *
     * @access public
     * @return int 条件に一致したページ総数
     */
    function getTotalPage()
    {
        return $this->total_page;
    }

    /**
     * 現在のページ番号を取得
     *
     * @access public
     * @return int 現在のページ番号
     */
    function getCurPage()
    {
        return $this->cur_page;
    }

    /**
     * 商品（オークション）情報を取得
     *
     * @access public
     * @return array 商品（オークション）情報
     */
    function getItems()
    {
        return $this->items;
    }
}
