<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpDAServiceResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - 日本語係り受け解析Webサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * 日本語係り受け解析Webサービス
 *   http://developer.yahoo.co.jp/jlp/DAService/V1/parse.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpDAServiceResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceJlpDAServiceResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 係り受け解析結果
     *
     * @access private
     * @var array
     */
     var $results = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;
        static $j = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 文節の情報
        case '/ResultSet/Result/ChunkList/Chunk': $i++; break;
        // 文節の番号
        case '/ResultSet/Result/ChunkList/Chunk/Id': $this->results[$i]['Id'] = $text; break;
        // 修飾するId
        case '/ResultSet/Result/ChunkList/Chunk/Dependency': $this->results[$i]['Dependency'] = $text; break;
        // 形態素情報のリスト
        case '/ResultSet/Result/ChunkList/Chunk/MorphemList': $this->results[$i]['MorphemeList'] = array(); $j = -1; break;
        // 形態素の情報
        case '/ResultSet/Result/ChunkList/Chunk/MorphemList/Morphem': $j++; break;
        // 形態素の表記
        case '/ResultSet/Result/ChunkList/Chunk/MorphemList/Morphem/Surface': $this->results[$i]['MorphemeList'][$j]['Surface'] = $text; break;
        // 形態素の読みがな
        case '/ResultSet/Result/ChunkList/Chunk/MorphemList/Morphem/Reading': $this->results[$i]['MorphemeList'][$j]['Reading'] = $text; break;
        // 形態素の基本形表記
        case '/ResultSet/Result/ChunkList/Chunk/MorphemList/Morphem/BaseForm': $this->results[$i]['MorphemeList'][$j]['BaseForm'] = $text; break;
        // 形態素の品詞
        case '/ResultSet/Result/ChunkList/Chunk/MorphemList/Morphem/POS': $this->results[$i]['MorphemeList'][$j]['POS'] = $text; break;
        // 形態素の全情報
        case '/ResultSet/Result/ChunkList/Chunk/MorphemList/Morphem/Feature': $this->results[$i]['MorphemeList'][$j]['Feature'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 係り受け解析結果を取得
     *
     * @access public
     * @return array 係り受け解析結果
     */
    function getResults()
    {
        return $this->results;
    }
}
