<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceNewsTopicsRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - ニュース - トピックスAPI）
 */
require_once 'SyL_WebServiceNewsTopicsResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - ニュース - トピックスAPI）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * ニュース - トピックスAPI
 *   http://developer.yahoo.co.jp/news/topics/V1/topics.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceNewsTopicsRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceNewsTopicsRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'news.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/NewsWebService/V1/Topics';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceNewsTopicsResponse';

    /**
     * トピック名をセットする
     *
     * @access public
     * @param string トピック名
     */
    function setTopicname($topicname)
    {
        parent::set('topicname', $topicname);
    }

    /**
     * 特定カテゴリをセットする
     *
     * @access public
     * @param string 特定カテゴリ
     */
    function setCategory($category)
    {
        switch ($category) {
        case 'domestic': //国内
        case 'world':    //海外
        case 'economy':  //経済
        case 'entertainment': //エンターテインメント
        case 'sports':   //スポーツ
        case 'computer': //コンピュータ
        case 'science':  //サイエンス
        case 'local':    //地域
            parent::set('category', $category);
            break;
        default:
            trigger_error("[SyL error] Invalid `category' property ({$category}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ワードをセットする
     *
     * @access public
     * @param string ワード
     */
    function setWord($word)
    {
        parent::set('word', $word);
    }

    /**
     * Yahoo! JAPANトップページへの掲載による絞り込み指定をセットする
     *
     * @access public
     * @param bool Yahoo! JAPANトップページへの掲載による絞り込み指定
     */
    function setTopflg($topflg)
    {
        $topflg = ($topflg) ? '1' : '';
        parent::set('topflg', $topflg);
    }

    /**
     * 見だしの有無
     *
     * @access public
     * @param bool 見だしの有無
     */
    function setMidashiflg($midashiflg)
    {
        $midashiflg = ($midashiflg) ? '1' : '';
        parent::set('midashiflg', $midashiflg);
    }

    /**
     * 関連トピックの表示
     *
     * @access public
     * @param bool 関連トピックの表示
     */
    function setRelatedtopics($relatedtopics)
    {
        $relatedtopics = ($relatedtopics) ? '1' : '0';
        parent::set('relatedtopics', $relatedtopics);
    }

    /**
     * 関連外部サイトの表示
     *
     * @access public
     * @param bool 関連外部サイトの表示
     */
    function setRelatedsite($relatedsite)
    {
        $relatedsite = ($relatedsite) ? '1' : '0';
        parent::set('relatedsite', $relatedsite);
    }

    /**
     * ソート項目をセットする
     *
     * @access public
     * @param string ソート項目
     */
    function setSort($sort)
    {
        switch ($sort) {
        case 'pvindex':   // PV指標順
        case 'topicname': // トピック名
        case 'datetime':  // 日付
            parent::set('sort', $sort);
            break;
        default:
            trigger_error("[SyL error] Invalid `sort' property ({$sort}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ソートの順序をセットする
     *
     * @access public
     * @param string ソートの順序
     */
    function setOrder($order)
    {
        switch ($order) {
        case 'a': // 昇順
        case 'd': // 降順
            parent::set('order', $order);
            break;
        default:
            trigger_error("[SyL error] Invalid `order' property ({$order}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 表示件数をセットする
     *
     * @access public
     * @param int 表示件数
     */
    function setNum($num)
    {
        if (preg_match('/^\d+$/', $num) && (($num >= 1) && ($num <= 30))) {
            parent::set('num', $num);
        } else {
            trigger_error("[SyL error] Invalid `num' property ({$num}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
