<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingCategorysearchRequest.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - カテゴリID取得用）
 */
require_once 'SyL_WebServiceShoppingCategorysearchResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - カテゴリID取得用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * カテゴリID取得
 *   http://developer.yahoo.co.jp/shopping/categorysearch/V1/categorySearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingCategorysearchRequest.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceShoppingCategorysearchRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'shopping.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/ShoppingWebService/V1/categorySearch';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceShoppingCategorysearchResponse';

    /**
     * Yahoo! JAPANアフィリエイト(yid)とバリューコマースアフィリエイト(vc)をセットする
     *
     * @access public
     * @param string Yahoo! JAPANアフィリエイト(yid)、またはバリューコマースアフィリエイト(vc)
     */
    function setAffiliateType($affiliate_type)
    {
        switch ($type) {
        case 'yid':
        case 'vc':
            parent::set('affiliate_type', $affiliate_type);
            break;
        default:
            trigger_error("[SyL error] Invalid `affiliate_type' property ({$affiliate_type}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Yahoo! JAPANアフィリエイトIDもしくは、バリューコマースアフィリエイトIDをセットする
     *
     * @access public
     * @param string Yahoo! JAPANアフィリエイトIDもしくは、バリューコマースアフィリエイトID
     */
    function setAffiliateId($affiliate_id)
    {
        parent::set('affiliate_id', $affiliate_id);
    }

    /**
     * JSONPとして出力する際のコールバック関数名をセットする
     *
     * @access public
     * @param string JSONPとして出力する際のコールバック関数名
     */
    function setCallback($callback)
    {
        parent::set('callback', $callback);
    }

    /**
     * カテゴリIDをセットする
     *
     * @access public
     * @param int カテゴリID
     */
    function setCategoryId($category_id)
    {
        if (preg_match('/^\d+$/', $category_id)) {
            parent::set('category_id', $category_id);
        } else {
            trigger_error("[SyL error] Invalid `category_id' property ({$category_id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
