<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcBuilderServer.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLRPC用XML作成クラス
 */
require_once 'SyL_XmlRpcBuilder.php';

/**
 * XMLRPC用レスポンス作成クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcBuilderServer.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlRpcBuilderServer extends SyL_XmlRpcBuilder
{
    /**
     * エラーコード
     * 
     * @access private
     * @var int
     */
    var $error_code = 0;
    /**
     * エラーメッセージ
     * 
     * @access private
     * @var array
     */
    var $error_message = '';

    /**
     * エラーコードをセットする
     *
     * @access public
     * @oaram int エラーコード
     */
    function setErrorCode($error_code)
    {
        $this->error_code = $error_code;
    }

    /**
     * エラーメッセージをセットする
     *
     * @access public
     * @oaram string エラーメッセージ
     */
    function setErrorMessage($error_message)
    {
        $this->error_message = $error_message;
    }

    /**
     * XMLRPC作成
     * 
     * @access public
     * @param object XMLライタオブジェクト
     */
    function buildXml(&$xml)
    {
        $xml->addStartElement('methodResponse');
        if ($this->error_code == 0) {
            $xml->addStartElement('params');

            $parameter = $this->gets();
            if (count($parameter) > 0) {
                list($name, $value) = each($parameter);
                $xml->addStartElement('param');
                $xml->addStartElement('value');
                list(, $format) = explode(':', $name, 2);
                $this->buildParameter($xml, $value, $format);
                $xml->addEndElement();
                $xml->addEndElement();
            }
            $xml->addEndElement();

        } else {
            $xml->addStartElement('fault');
            $xml->addStartElement('value');
            $xml->addStartElement('struct');

            $xml->addStartElement('member');
            $xml->addElement('name', array(), 'faultCode');
            $xml->addStartElement('value');
            $xml->addElement('int', array(), $this->error_code);
            $xml->addEndElement();
            $xml->addEndElement();

            $xml->addStartElement('member');
            $xml->addElement('name', array(), 'faultString');
            $xml->addStartElement('value');
            $xml->addElement('string', array(), $this->error_message);
            $xml->addEndElement();
            $xml->addEndElement();

            $xml->addEndElement();
            $xml->addEndElement();
            $xml->addEndElement();
        }
        $xml->addEndElement();
    }
}
