<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClientResponse.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * HTTPリクエスト結果クラス
 */
require_once dirname(__FILE__) . '/../../Http/SyL_HttpClientResponse.php';
/**
 * XMLRPCクライアントリクエスト結果パーサークラス
 */
require_once 'SyL_XmlRpcClientReader.php';

/**
 * XMLRPCクライアントリクエストクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClientResponse.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlRpcClientResponse extends SyL_HttpClientResponse
{
    /**
     * 元の文字コード
     *
     * @access protected
     * @var string
     */
    var $original_encode = 'UTF-8';
    /**
     * XMLRPC リーダーオブジェクト
     *
     * @access private
     * @var object
     */
    var $reader = null;

    /**
     * コンストラクタ
     * 
     * @access public
     * @param string リクエスト結果
     * @param string クライアントエンコード
     */
    function SyL_XmlRpcClientResponse($data, $client_encode='')
    {
        parent::SyL_HttpClientResponse($data, $client_encode);

        // 先頭から100バイト目までにエンコーディングの定義があったら取得
        if (preg_match ('/<\?xml(.+)encoding=\"([^\"]+)\"(.*)\?>/i', substr(ltrim($this->body), 0, 100), $matches)) {
            $this->original_encode = $matches[2];
        }

        $this->reader =& new SyL_XmlRpcClientReader();
        if ($this->original_encode) {
            $this->reader->setXmlEncode($this->original_encode);
        }
        if ($this->client_encode) {
            $this->reader->setClientEncode($this->client_encode);
        }
        $this->reader->setData($this->body);
        $this->reader->parseXml();
    }

    /**
     * XML RPCの戻り値を取得
     * 
     * @access public
     * @return mixed XML RPCの戻り値
     */
    function getResult()
    {
        return $this->reader->getValue();
    }

    /**
     * XML RPCのエラー判定
     * 
     * @access public
     * @return bool true: エラーあり、false: エラーなし
     */
    function isError()
    {
        return $this->reader->isError();
    }

    /**
     * エラーコードを取得する
     *
     * @access public
     * @return string エラーコード
     */
    function getErrorCode()
    {
        return $this->reader->getErrorCode();
    }

    /**
     * エラーメッセージを取得する
     *
     * @access public
     * @return string エラーメッセージ
     */
    function getErrorMessage()
    {
        return $this->reader->getErrorMessage();
    }
}
