<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriter1_0.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * RSS 1.0作成クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriter1_0.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlRssWriter1_0 extends SyL_XmlRssWriter
{
    /**
     * 画像要素をセットする
     * 
     * @access public
     * @param array 要素配列
     */
    function setImage($value)
    {
        parent::setImage($value);
        if (isset($this->image['height'])) {
            unset($this->image['height']);
        }
        if (isset($this->image['width'])) {
            unset($this->image['width']);
        }
    }

    /**
     * チャネル要素をセットする
     * 
     * @access public
     * @param string 要素名
     * @param string 要素値
     * @param array 属性配列
     */
    function setChannel($name, $value, $attributes=array())
    {
        // 抽象化名変換
        switch ($name) {
        case 'copyright':   $name = 'dc:right';    break;
        case 'language':    $name = 'dc:language'; break;
        case 'category':    $name = 'dc:subject';  break;
        case 'contributor': $name = 'dc:contributor'; break;
        case 'author':      $name = 'dc:creator'; break;
        case 'id':          $name = 'dc:identifier'; break;
        case 'date':
            $name = 'dc:date';
        case 'dc:date':
            $value = $this->convertDateTime($value);
            break;
        }
        parent::setChannel($name, $value, $attributes);
    }

    /**
     * 項目をセットする
     * 
     * @access public
     * @param string 要素名
     * @param string 要素値
     * @param array 属性配列
     */
    function addItem($values, $attributes=array())
    {
        // 抽象化名変換
        foreach (array_keys($values) as $name) {
            switch ($name) {
            case 'author':
                $values['dc:creator'] = $values[$name];
                unset($values[$name]);
                break;
            case 'category':
                $values['dc:subject'] = $values[$name];
                unset($values[$name]);
                break;
            case 'contributor':
                $values['dc:contributor'] = $values[$name];
                unset($values[$name]);
                break;
            case 'copyright':
                $values['dc:right'] = $values[$name];
                unset($values[$name]);
                break;
            case 'date':
                $values['dc:date'] = $this->convertDateTime($values[$name]);
                unset($values[$name]);
                break;
            case 'dc:date':
                $values['dc:date'] = $this->convertDateTime($values[$name]);
                break;
            case 'id':
                $values['dc:identifier'] = $values[$name];
                unset($values[$name]);
                break;
            case 'source':
                $values['dc:source'] = $values[$name];
                unset($values[$name]);
                break;
            }
        }
        parent::addItem($values, $attributes);
    }

    /**
     * RSS XMLを作成する
     * 
     * @access public
     */
    function createXml()
    {
        $rdf_about = '';
        foreach ($this->channel as $values) {
            if ($values[0] == 'link') {
                $rdf_about = $values[1];
                break;
            }
        }

        $this->addStartElement('rdf:RDF',
          array(
            'xmlns'     => 'http://purl.org/rss/1.0/',
            'xmlns:rdf' => 'http://www.w3.org/1999/02/22-rdf-syntax-ns#',
            'xmlns:dc'  => 'http://purl.org/dc/elements/1.1/'
          )
        );
        $this->addStartElement('channel', array('rdf:about' => $rdf_about));
        // チャネル要素
        foreach ($this->channel as $values) {
            $this->createRecursiveElements($values[0], $values[1]);
        }
        // 画像要素
        if (count($this->image) > 0) {
            $this->addElement('image', array('rdf:resource' => $this->image['url']));
        }
        // テキスト要素
        if (count($this->textinput) > 0) {
            $this->addElement('textinput', array('rdf:resource' => $this->textinput['link']));
        }
        // アイテム要素
        if (count($this->items) > 0) {
            $this->addStartElement('items');
            $this->addStartElement('rdf:Seq');
            foreach ($this->items as $item) {
                $this->addElement('rdf:li', array('resource' => $item['link']));
            }
            $this->addEndElement();
            $this->addEndElement();
        }
        $this->addEndElement();

        // 画像要素
        if (count($this->image) > 0) {
            $this->addStartElement('image', array('rdf:about' => $this->image['url']));
            foreach ($this->image as $name => $value) {
                $this->createRecursiveElements($name, $value);
            }
            $this->addEndElement();
        }

        // テキスト要素
        if (count($this->textinput) > 0) {
            $this->addStartElement('textinput', array('rdf:about' => $this->image['link']));
            foreach ($this->textinput as $name => $value) {
                $this->createRecursiveElements($name, $value);
            }
            $this->addEndElement();
        }

        // アイテム要素
        foreach ($this->items as $item) {
            $this->addStartElement('item', array('rdf:about' => $item['link']));
            foreach ($item as $name => $value) {
                $this->createRecursiveElements($name, $value);
            }
            $this->addEndElement();
        }

        $this->addEndElement();
        $this->addEndElement();
    }

    /**
     * 時刻フォーマットを変換する
     *
     * 例） 2007/03/14 19:44:00 -> 2007-03-14T19:44:00+09:00
     *
     * @access public
     * @param string 変換前時刻
     * @return string 変換後時刻
     */
    function convertDateTime($datetime)
    {
        if (preg_match('/^([0-9]{4})[\-|\/]?([0-1][0-9])[\-|\/]?([0-3][0-9])[ ]*([0-2][0-9]:?[0-5][0-9]:?[0-5][0-9])?$/', trim($datetime))) {
            $timestamp = @strtotime($datetime);
            if ($timestamp) {
                $datetime = date('Y-m-d\TH:i:s+09:00', $timestamp);
            }
        }
        return $datetime;
    }

}
