<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: CreateApplication.php,v 1.11 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * アプリケーションディレクトリ作成コンポーネントクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: CreateApplication.php,v 1.11 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class CreateApplication
{
    /**
     * アプリケーションディレクトリ作成
     *
     * @access public
     * @param object コンソールオブジェクト
     * @param string プロジェクトディレクトリ
     * @param string アプリケーション名
     */
    function trigger(&$cmd, $project_dir, $app_name)
    {
        $app_dir = "{$project_dir}apps/{$app_name}/";
        if (!is_dir($app_dir)) {
            $cmd->stdout("  -> creating directory {$app_dir}");
            if (!mkdir($app_dir, 0755)) {
                trigger_error("[SyL error] Application directory can't create ({$app_dir})", E_USER_ERROR);
                exit;
            }
        }

        $dirs = array(
          'actions'   => 0755,
          'config'    => 0755,
          'lib'       => 0755,
          'lib/App'   => 0755,
          'templates' => 0755,
          "../../var/cache/{$app_name}" => 0755,
          "../../var/cache/{$app_name}/app" => 0777,
          "../../var/cache/{$app_name}/config" => 0777,
          "../../var/logs/{$app_name}" => 0777,
          "../../var/smarty/{$app_name}" => 0755,
          "../../var/smarty/{$app_name}/templates_c" => 0777,
          "../../var/syslogs/{$app_name}" => 0777,
        );

        $files = array(
          'actions.xml'     => 'config/actions.xml',
          'defines_app.xml' => 'config/defines.xml',
          'filters.xml'     => 'config/filters.xml',
          'layouts.xml'     => 'config/layouts.xml',
          'routers.xml'     => 'config/routers.xml',
          'Error404.php'    => 'lib/Error404.php',
          'Error500.php'    => 'lib/Error500.php',
          'AppAction.php'   => 'lib/App/AppAction.php',
          'AppUser.php'     => 'lib/App/AppUser.php'
        );

        foreach ($dirs as $dir => $mode) {
            if (!is_dir($app_dir . $dir)) {
                $cmd->stdout("  -> creating directory {$app_dir}{$dir}");
                mkdir("{$app_dir}{$dir}");
                chmod("{$app_dir}{$dir}", $mode);
            }
        }

        foreach ($files as $file_org => $file_dist) {
            $cmd->stdout("  -> copying file {$app_dir}{$file_dist}");
            if (file_exists("{$project_dir}var/skel-templates/{$file_org}")) {
                copy("{$project_dir}var/skel-templates/{$file_org}", "{$app_dir}{$file_dist}");
            } else {
                copy(SYL_PROJECT_DIR . "/var/skel-templates/{$file_org}", "{$app_dir}{$file_dist}");
            }
        }
    }
}
