<?php
/**
 * 入力値検証（バリデーション）サンプル2のフォームクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Example2Form.php,v 1.2 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class Example2Form extends SyL_ActionForm
{
    var $elements_config = array(
        'lastname' => array(
            'type'         => 'text',
            'name' => '名前（姓）',
            'attributes'   => array('size' => '30'),
            'validate'     => array(
                'require' => array(
                    'message' => '{name}は必須です'
                ),
                'length' => array(
                    'message'    => '{name}は最大{max}文字（バイト）まで入力できます',
                    'parameters' => array('max' => 20)
                )
            )
        ),
        'firstname' => array(
            'type'         => 'text',
            'name' => '名前（名）',
            'attributes'   => array('size' => '30'),
            'validate'     => array(
                'require' => array(
                    'message' => '{name}は必須です'
                ),
                'length' => array(
                    'message'    => '{name}は最大{max}文字（バイト）まで入力できます',
                    'parameters' => array('max' => 20)
                )
            )
        ),
        'gender' => array(
            'type'         => 'radio',
            'name' => '性別',
            'options'      => array(
                '1' => '男',
                '2' => '女'
            ),
            'validate'     => array(
                'require' => array(
                    'message' => '{name}は必須です'
                )
            )
        ),
        'prefecture' => array(
            'type'         => 'select',
            'name' => '都道府県',
            'options'      => array(
                ''   => '選択してください',
                '01' => '北海道',
                '02' => '青森県',
                '03' => '岩手県',
                '04' => '宮城県',
                '05' => '秋田県',
                '06' => '山形県',
                '07' => '福島県',
                '08' => '茨城県',
                '09' => '栃木県',
                '10' => '群馬県',
                '11' => '埼玉県',
                '12' => '千葉県',
                '13' => '東京都',
                '14' => '神奈川県',
                '15' => '新潟県',
                '16' => '富山県',
                '17' => '石川県',
                '18' => '福井県',
                '19' => '山梨県',
                '20' => '長野県',
                '21' => '岐阜県',
                '22' => '静岡県',
                '23' => '愛知県',
                '24' => '三重県',
                '25' => '滋賀県',
                '26' => '京都府',
                '27' => '大阪府',
                '28' => '兵庫県',
                '29' => '奈良県',
                '30' => '和歌山県',
                '31' => '鳥取県',
                '32' => '島根県',
                '33' => '岡山県',
                '34' => '広島県',
                '35' => '山口県',
                '36' => '徳島県',
                '37' => '香川県',
                '38' => '愛媛県',
                '39' => '高知県',
                '40' => '福岡県',
                '41' => '佐賀県',
                '42' => '長崎県',
                '43' => '熊本県',
                '44' => '大分県',
                '45' => '宮崎県',
                '46' => '鹿児島県',
                '47' => '沖縄県'
            ),
            'validate'     => array(
                'require' => array(
                    'message' => '{name}は必須です'
                )
            )
        ),
        'tel' => array(
            'type'         => 'text',
            'name' => '電話番号',
            'attributes'   => array('size' => '20'),
            'validate'     => array(
                'regex' => array(
                    'message' => '{name}が正しくありません',
                    'parameters' => array('format'=> '/^[0-9]+\-[0-9]+\-[0-9]{4}$/')
                )
            )
        ),
        'mailaddress' => array(
            'type'         => 'text',
            'name' => 'メールアドレス',
            'attributes'   => array('size' => '30'),
            'validate'     => array(
                'require' => array(
                    'message' => '{name}は必須です'
                ),
                'email' => array(
                    'message' => '{name}の形式が正しくありません'
                )
            )
        ),
        'blowser' => array(
            'type'         => 'checkbox',
            'name' => 'よく使用するブラウザ',
            'attributes'   => array('separator' => '<br>'),
            'options'      => array(
                '01' => 'Internet Explorer',
                '02' => 'Fire Fox',
                '03' => 'Opera',
                '04' => 'Safari',
            )
        )

    );
}

?>
