<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowFin.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 管理フローの基底クラス
 */
require_once SYL_FRAMEWORK_DIR . '/core/Adm/SyL_AdmFlow.php';

/**
 * 管理フロー完了クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowFin.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_AdmFlowFin extends SyL_AdmFlow
{
    /**
     * オペレーション名
     *
     * @access protected
     * @var string
     */
    var $opp_name = 'fin';

    /**
     * コンストラクタ
     *
     * @access public
     */
    function SyL_AdmFlowFin()
    {
        parent::SyL_AdmFlow();
    }

    /**
     * 完了表示フロー
     *
     * @access public
     * @param object データ管理オブジェクト
     * @param object コンテキスト管理オブジェクト
     */
    function execute(&$data, &$context)
    {
        // フォーム取得
        $form =& $this->getForm();
        if ($form->getStructConfig('view_fin') === false) {
            SyL_Response::redirect($this->getUrl($context, 'lst'));
        }

        switch ($data->get('adm_action')) {
        case 'new':
        case 'upd':
        case 'del':
            $data->set('adm_action', $data->get('adm_action'));
            break;
        default:
            SyL_Response::redirect($this->getUrl($context, 'lst'));
        }

        // 文言関連
        $data->set('title', $form->getStructConfig('title'));

        // リンク先URL
        $data->set('url_lst', $this->getUrl($context, 'lst'));
        $data->set('url_dir', dirname($context->getScriptName()));
    }

}
