<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowIndex.php,v 1.1 2009/02/14 04:32:56 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 管理フローの基底クラス
 */
require_once SYL_FRAMEWORK_DIR . '/core/Adm/SyL_AdmFlow.php';

/**
 * 管理メニューインデックスクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowIndex.php,v 1.1 2009/02/14 04:32:56 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_AdmFlowIndex extends AppAction
{
    /**
     * 一覧表示フロー
     *
     * @access public
     * @param object データ管理オブジェクト
     * @param object コンテキスト管理オブジェクト
     */
    function execute(&$data, &$context)
    {
        $adm_config =& SyL_Config::factory('adms');
        $adm_config->parseXml();
        $config = $adm_config->getConfig();

        $index_list = array();
        if (isset($config['adm'])) {
            $base_path = $config['base'];

            foreach ($config['adm'] as $adm) {
                $menu = array();
                if (isset($adm['link']) && $adm['link']) {
                    $menu['link'] = $adm['link'];
                } else {
                    $menu['link'] = $base_path . $adm['pathinfo'];
                }

                $form =& SyL_AdmActionForm::factory($adm['class']);
                $menu['title']   = $form->getStructConfig('title');
                $menu['summary'] = $form->getStructConfig('summary');

                $index_list[] = $menu;
            }
        }

        // リンク先（ADM）情報
        $data->set('index_list', $index_list);
        // リンク先URL
        $data->set('url_dir', dirname($context->getScriptName()));
    }

}
