<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlow.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ADM対応アクションフォームクラス
 */
require_once 'SyL_AdmActionForm.php';
/**
 * DBクラス
 */
require_once SYL_FRAMEWORK_DIR . '/lib/SyL_DB.php';
/**
 * 上位レイヤーデータ管理クラス
 */
require_once SYL_FRAMEWORK_DIR . '/core/SyL_Adm.php';

/**
 * 管理フローの基底クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlow.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_AdmFlow extends AppAction
{
    /**
     * ベースURL
     *
     * @access protected
     * @var string
     */
    var $script_name = '';
    /**
     * PATH_INFOベースディレクトリ
     *
     * @access protected
     * @var string
     */
    var $pathinfo_base = '';
    /**
     * オペレーション名
     *
     * @access protected
     * @var string
     */
    var $opp_name = '';
    /**
     * アクションフォームクラス名
     *
     * @access protected
     * @var string
     */
    var $classname = '';

    /**
     * コンストラクタ
     *
     * @access public
     */
    function SyL_AdmFlow()
    {
        // PATH_INFOベースディレクトリを取得
        $this->setPathinfoBase();
    }

    /**
     * ADMアクションフォームオブジェクトを取得する
     *
     * @access public
     * @return object ADMアクションフォームオブジェクト
     */
    function &getForm()
    {
        static $form = null;
        if ($form == null) {
            $form =& SyL_AdmActionForm::factory($this->classname);
            $form->setType($this->opp_name);
        }
        return $form;
    }

    /**
     * PATH_INFOベースディレクトリをセットする
     *
     * @access protected
     */
    function setPathinfoBase()
    {
        if (isset($_SERVER['PATH_INFO'])) {
            $this->pathinfo_base = $_SERVER['PATH_INFO'];
            if (substr($this->pathinfo_base, -1) != '/') {
                $this->pathinfo_base = dirname($_SERVER['PATH_INFO']) . '/';
            } else {
                if ($this->pathinfo_base == '') {
                    $this->pathinfo_base = '/';
                }
            }
        }
    }

    /**
     * オペレーション別URLを取得
     *
     * @access protected
     * @param object コンテキストオブジェクト
     * @param string オペレーション名
     * @return string オペレーションURL
     */
    function getUrl(&$context, $opp_name='')
    {
        if (!$opp_name) {
            $opp_name = $this->opp_name;
        }
        return $context->getScriptName() . "{$this->pathinfo_base}{$opp_name}" . SYL_ROUTER_URL_EXT;
    }
}
