<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigAdms.php,v 1.1 2009/02/14 04:32:56 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ADM設定ファイルを読み込むクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigAdms.php,v 1.1 2009/02/14 04:32:56 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ConfigAdms extends SyL_Config
{
    /**
     * 設定ファイル名
     * 
     * @access private
     * @var string
     */
    var $config_file_name = 'adms.xml';

    /**
     * 設定ファイルをセット
     *
     * @access protected
     */
    function setProjectConfigFiles()
    {
        $config = SYL_APP_CONFIG_DIR . "/{$this->config_file_name}";
        if (is_file($config)) {
            $this->file_names[] = $config;
        }
    }

    /**
     * XMLファイルの解析処理
     *
     * @access public
     * @param bool キャッシュ有効フラグ
     */
    function parseXml($enable_cache=true)
    {
        if (SYL_CACHE && $enable_cache) {
            // キャッシュを使用する
            $key = SYL_APP_DIR;
            $cache =& $this->getCache($key);
            if ($cache) {
                // キャッシュが取得できなかった場合（キャッシュオブジェクトを取得した場合）
                parent::parseXml();
                $cache->write($this->config);
            }
        } else {
            // キャッシュを使用しない
            parent::parseXml();
        }
    }

    /**
     * XMLデータ内容取得ハンドラメソッド
     * ※オーバーライド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        // XML解析結果を取得
        switch ($current_path) {
        case '/syl-adms/base':
            $this->config['base'] = $attribute['path'];
            break;

        case '/syl-adms/adm':
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                return;
            }

            $config['class']    = $attribute['class'];
            $config['link']     = isset($attribute['link']) ? $attribute['link'] : null;
            $config['pathinfo'] = isset($attribute['pathinfo']) ? $attribute['pathinfo'] : null;
            $this->config['adm'][] = $config;
            break;
        }
    }
}
