<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigDefines.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 設定ファイルを読み込み、定数化するクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigDefines.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ConfigDefines extends SyL_Config
{
    /**
     * 設定ファイル名
     * 
     * @access private
     * @var string
     */
    var $config_file_name = 'defines.xml';

    /**
     * 設定ファイルをセット
     *
     * @access protected
     */
    function setProjectConfigFiles()
    {
        // アプリケーション設定値を読み込み定数化
        $config = SYL_APP_CONFIG_DIR . "/{$this->config_file_name}";
        if (is_file($config)) {
            $this->file_names[] = $config;
        }
        // プロジェクト設定値を読み込み定数化
        $this->file_names[] = SYL_PROJECT_CONFIG_DIR . "/{$this->config_file_name}";
    }

    /**
     * 設定ファイルをセット
     *
     * @access public
     * @param string or array 設定ファイルのパス
     * @param bool プロジェクト設定ファイル無効フラグ
     */
    function setConfigFiles($config, $this_only=true)
    {
        if ($this_only) {
            $this->file_names = array();
        }
        if (!is_array($config)) {
            $config = (array)$config;
        }
        $this->file_names = array_merge($this->file_names, $config);
    }

    /**
     * XMLファイルの解析処理
     *
     * @access public
     * @param bool キャッシュ有効フラグ
     * @param bool 定数変換フラグ
     */
    function parseXml($enable_cache=true, $change_constants=true)
    {
        if (SYL_CACHE && $enable_cache) {
            // キャッシュを使用する
            $key = SYL_APP_DIR;
            $cache =& $this->getCache($key);
            if ($cache) {
                // キャッシュが取得できなかった場合（キャッシュオブジェクトを取得した場合）
                parent::parseXml();
                // キャッシュ保存
                //$cache->setSerialize(false);
                $cache->write($this->config);
            }
        } else {
            // キャッシュを使用しない
            parent::parseXml();
        }

        // 定数一括変換
        if ($change_constants) {
            $this->readConstants();
        }
    }

    /**
     * XMLデータ内容取得ハンドラメソッド
     * ※オーバーライド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        if ($current_path == '/syl-defines/define') {
            $this->config[$attribute['name']] = $text;
        }
    }

    /**
     * 定数読み込み
     *
     * @access private
     */
    function readConstants()
    {
        static $defined = false;
        foreach ($this->config as $key => $value) {
            $value = preg_replace_callback('/\{(\w+)\}/', array(&$this, 'replaceConstants'), $value);
            $this->config[$key] = $value;
            if (!$defined) define($key, $value);
        }
        $defined = true;
    }

    /**
     * 定数置き換えコールバックメソッド
     *
     * @access private
     * @param array マッチした配列
     * @return mixed マッチした定数値
     */
    function replaceConstants($matches)
    {
        if (isset($this->config[$matches[1]])) {
            return $this->config[$matches[1]];
    } else if (defined($matches[1])) {
            return constant($matches[1]);
        } else {
            return '{' . $matches[1] . '}';
        }
    }
}
