<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigLayouts.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * レイアウト設定ファイルを読み込むクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigLayouts.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ConfigLayouts extends SyL_Config
{
    /**
     * 設定ファイル名
     * 
     * @access private
     * @var string
     */
    var $config_file_name = 'layouts.xml';

    /**
     * 設定ファイルをセット
     *
     * @access protected
     */
    function setProjectConfigFiles()
    {
        // アプリケーションレイアウト設定ファイル
        $config = SYL_APP_CONFIG_DIR . "/{$this->config_file_name}";
        if (is_file($config)) {
            $this->file_names[] = $config;
        }
        // プロジェクトレイアウト設定ファイル
        $config = SYL_PROJECT_CONFIG_DIR . "/{$this->config_file_name}";
        if (is_file($config)) {
            $this->file_names[] = $config;
        }
    }

    /**
     * XMLファイルの解析処理
     *
     * @access public
     * @param bool キャッシュ有効フラグ
     */
    function parseXml($enable_cache=true)
    {
        if (SYL_CACHE && $enable_cache) {
            // キャッシュを使用する
            $key = SYL_APP_DIR . $this->router->getActionFile();
            $cache =& $this->getCache($key);
            if ($cache) {
                // キャッシュが取得できなかった場合（キャッシュオブジェクトを取得した場合）
                parent::parseXml();
                $cache->write($this->config);
            }
        } else {
            // キャッシュを使用しない
            parent::parseXml();
        }

        if (!isset($this->config['file'])) {
            // 対応するレイアウトマッピングが存在しない場合
            trigger_error("[SyL error] Layout mapping not found (Layout name: " . $this->router->getLayoutName() . ")", E_USER_ERROR);
        }
    }

    /**
     * XMLデータ内容取得ハンドラメソッド
     * ※オーバーライド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $layout    = 0;
        static $parameter = 0;

        // 1アクションロード済みの場合以降スキップ
        if ($layout > 1) return;

        // XML解析結果を取得
        switch ($current_path) {
        case '/syl-layouts/layout':
            if ($layout == 1) {
                $layout = 2;
                return;
            }
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                return;
            }

            // レイアウト名判定
            if ($attribute['name'] == $this->router->getLayoutName()) {
                $layout = 1;
                $this->config['file']       = $attribute['file'];
                $this->config['templates']  = array();
                $this->config['content']    = array();
                $this->config['parameters'] = array();
            }
            break;

        default:
            if ($layout == 0) return;

            switch ($current_path) {
            case '/syl-layouts/layout/template':
                $this->config['templates'][$attribute['name']] = $attribute['file'];
                break;

            case '/syl-layouts/layout/content':
                $this->config['content'] = $attribute['name'];
                break;

            case '/syl-layouts/layout/params/action':
                if ($parameter > 1) return;
                if ($parameter == 1) {
                    $parameter = 2;
                    return;
                }
                $reg = isset($attribute['path']) ? str_replace('/', '\\/', $attribute['path']) : '(.*)';
                // アクションファイル取得用ルータオブジェクト
                if (preg_match('/^' . $reg . '$/', '/' . $this->router->getActionFile())) {
                    $parameter = 1;
                }
                break;

            case '/syl-layouts/layout/params/action/param':
                if ($parameter == 1) {
                    // 追加静的パラメータ
                    $this->config['params'][$attribute['name']] = $attribute['value'];
                }
                break;
            }
        }
    }
}
