<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigRouters.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ルーティング設定ファイルを読み込むクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigRouters.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ConfigRouters extends SyL_Config
{
    /**
     * 設定ファイル名
     * 
     * @access private
     * @var string
     */
    var $config_file_name = 'routers.xml';

    /**
     * 設定ファイルをセット
     *
     * @access protected
     */
    function setProjectConfigFiles()
    {
        $config = SYL_APP_CONFIG_DIR . "/{$this->config_file_name}";
        if (is_file($config)) {
            $this->file_names[] = $config;
        }
    }

    /**
     * XMLファイルの解析処理
     *
     * @access public
     * @param bool キャッシュ有効フラグ
     */
    function parseXml($enable_cache=true)
    {
        if (count($this->file_names) > 0) {
            if (SYL_CACHE && $enable_cache) {
                // キャッシュを使用する
                $key = SYL_APP_DIR . $this->router->getActionFile();
                $cache =& $this->getCache($key);
                if ($cache) {
                    // キャッシュが取得できなかった場合（キャッシュオブジェクトを取得した場合）
                    parent::parseXml();
                    $cache->write($this->config);
                }
            } else {
                // キャッシュを使用しない
                parent::parseXml();
            }
        }
    }

    /**
     * XMLデータ内容取得ハンドラメソッド
     * ※オーバーライド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $load = false;

        // 1アクションロード済みの場合以降スキップ
        if ($load) return;

        // XML解析結果を取得
        switch ($current_path) {
        case '/syl-routers/router':
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                return;
            }

            // アクセスアクション名確認
            $reg = isset($attribute['path']) ? str_replace('/', '\\/', $attribute['path']) : '(.*)';
            // アクションファイル取得用ルータオブジェクト
            if (preg_match('/^' . $reg . '$/', '/'.$this->router->getActionFile())) {
                $load = true;
                $enable_action   = true;
                $enable_template = true;
                if (isset($attribute['enableAction'])) {
                    $enable_action = ($attribute['enableAction'] == 'true');
                }
                if (isset($attribute['enableTemplate'])) {
                    $enable_template = ($attribute['enableTemplate'] == 'true');
                }

                if (!$enable_action && !$enable_template) {
                    break;
                }

                $this->config = array();
                $this->config['forwardAction']   = isset($attribute['forwardAction'])   ? $attribute['forwardAction']   : '';
                $this->config['forwardTemplate'] = isset($attribute['forwardTemplate']) ? $attribute['forwardTemplate'] : '';
                $this->config['viewType']        = isset($attribute['viewType'])      ? $attribute['viewType']      : '';
                $this->config['layoutName']      = isset($attribute['layoutName'])    ? $attribute['layoutName']    : '';
                $this->config['enableAction']    = $enable_action;
                $this->config['enableTemplate']  = $enable_template;
            }
            break;
        }
    }
}
