<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ControllerXmlrpc.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBコントローラクラス
 */
require_once 'SyL_ControllerWeb.php';

/**
 * XMLRPCコントローラクラス
 *
 * ++ 遷移イベント
 *   1. initStream         - コントローラーのコンストラクタ実行後
 *   2.   loadStream       - アクション実行前
 *   3.     executeStream  - アクション実行
 *   4.       middleStream - アクション実行後、ビュー表示実行前
 *   5.     renderStream   - ビュー表示実行
 *   6.   unloadStream     - ビュー表示実行後
 *   7. finalStream        - shutdown時
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ControllerXmlrpc.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ControllerXmlrpc extends SyL_ControllerWeb
{
/*
        // 環境変数チェック
        if (!isset($_SERVER['CONTENT_TYPE'])) {
            trigger_error("[SyL error] Content-Type header not found", E_USER_ERROR);
        }
        if (!preg_match('/text\/xml/i', $_SERVER['CONTENT_TYPE'])) {
            trigger_error("[SyL error] Invalid Content-Type header", E_USER_ERROR);
        }
        if (!isset($_SERVER['HTTP_USER_AGENT'])) {
            trigger_error("[SyL error] User_Agent header not found", E_USER_ERROR);
        }
        if (!isset($_SERVER['HTTP_HOST'])) {
            trigger_error("[SyL error] Host header not found", E_USER_ERROR);
        }
*/
}
