<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataJs.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * JavaScriptデータ保持クラス
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataJs.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_DataJs extends SyL_Data
{
    /**
     * JavaScript出力情報
     * 
     * @access private
     * @var string
     */
    var $javascript = '';
    /**
     * JavaScript入力クラス
     * 
     * @access private
     * @var array
     */
    var $imports = array();
    /**
     * 外部インポートパラメータ名
     *
     * @access private
     * @var string
     */
    var $import_parameter = SYL_JS_AUTO_IMPORT_PARAMETER;
    /**
     * インポートファイルの分割句
     *
     * @access private
     * @var string
     */
    var $separater = SYL_JS_AUTO_IMPORT_SEPARATER;
    /**
     * JSONPコールバック関数名
     * 
     * @access private
     * @var array
     */
    var $js_callback = '';
    /**
     * JSONPコールバックパラメータ名
     *
     * @access private
     * @var string
     */
    var $js_callback_parameter = 'callback';

    /**
     * JSONPコールバック関数をセット
     * 
     * @access public
     * @param string JSONPコールバック関数
     */
    function setJsCallback($js_callback)
    {
        $this->js_callback = $js_callback;
    }

    /**
     * JSONPコールバック関数を取得
     * 
     * @access public
     * @return string JSONPコールバック関数
     */
    function getJsCallback()
    {
        return $this->js_callback;
    }

    /**
     * JavaScript出力情報をセット
     * 
     * @access public
     * @param string JavaScript出力情報
     */
    function setJs($javascript)
    {
        $this->javascript = $javascript;
    }

    /**
     * JavaScript出力情報を取得
     * 
     * @access public
     * @return string JavaScript出力情報
     */
    function getJs()
    {
        return $this->javascript;
    }

    /**
     * コード入力クラスを追加
     * 
     * @access public
     * @param string コード入力クラス
     */
    function addImport($import)
    {
        $this->imports = array_merge($this->imports, (array)$import);
    }

    /**
     * コード入力クラスを取得
     * 
     * @access public
     * @return array コード入力クラス
     */
    function getImport()
    {
        return $this->imports;
    }

    /**
     * JSインポートパラメータをセット
     * 
     * @access protected
     */
    function setImportParameter()
    {
        $js = $this->get($this->import_parameter);
        if ($js) {
            foreach (explode($this->separater, $js) as $import) {
                $this->addImport($import);
            }
        }
    }

    /**
     * 初期入力パラメータをセット
     * 
     * @access protected
     */
    function initInputs()
    {
        // パラメータ取得
        $this->setInputs(($_SERVER['REQUEST_METHOD'] == 'POST') ? $_POST + $_GET : $_GET + $_POST);
        // 入力エンコーディングに変換
        $this->apply('mb_convert_encoding', SYL_ENCODE_INTERNAL, SYL_ENCODE_JS);
        // マジッククォ－トが有効判定
        if (get_magic_quotes_gpc()) {
            $this->apply('stripslashes');
        }
        // 文字コードチェック追加
        if (function_exists('mb_check_encoding')) {
            $this->applyCheckEncodingRecursive($this->input_parameters, SYL_ENCODE_INTERNAL);
        }

        // 外部指定JSインポートパラメータ
        if ($this->import_parameter) {
            $this->setImportParameter();
        }
        // JSONPコールバック関数パラメータ取得
        $js_callback = $this->get($this->js_callback_parameter);
        if (is_string($js_callback)) {
            // コールバック関数チェック
            if (preg_match('/^[a-zA-Z0-9_\$\.\[\]]+$/', $js_callback)) {
                $this->js_callback = $js_callback;
            } else {
                trigger_error("[SyL error] Invalid javascript callback function ({$js_callback})", E_USER_ERROR);
            }
        }
    }

    /**
     * 最後的にパラメータを取得するメソッド
     * 
     * @access public
     * @return array パラメータ
     */
    function finalOutputs()
    {
        // 出力エンコーディングに変換
        $this->apply('mb_convert_encoding', SYL_ENCODE_JS, SYL_ENCODE_INTERNAL);
        $parameters = $this->gets(false);
        $this->deletes();
        return $parameters;
    }
}
