<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorCmd.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * コマンドエラークラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorCmd.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ErrorCmd extends SyL_Error
{
    /**
     * 404 Not Found の表示内容
     *
     * @access public
     */
    function forwardFileNotFoundDetail()
    {
        SyL_Loggers::warn("[SyL error] Action file or action method Not Found");
        echo "[SyL error] Action file or action method Not Found\n";
    }

    /**
     * 環境別エラー処理
     * 
     * @access public
     * @param array エラーメッセージ配列
     * @param array エラートレース
     */
    function displayError($error_messages, $error_trace)
    {
        // display_errorsがoffの場合はエラー画面を表示しない
        if (!ini_get('display_errors')) {
            return;
        }

        // エラーメッセージ取得
        $error_message = implode($this->eol, $error_messages) . $this->eol;
        // エラーメッセージ表示
        echo $error_message;
        echo $this->getTraceConsole($error_trace);
    }

    /**
     * エラートレースを取得
     *
     * @access public
     * @return array エラートレース
     * @return string エラートレース
     */
    function getTraceConsole($error_trace)
    {
        $error_trace_result = '';
        if (count($error_trace) > 0) {
            $error_trace_result = $this->eol;

            // エラートレース表示の作成
            $error_trace_result .= "------ start Stack Trace ------" . $this->eol;
            foreach ($error_trace as $value) {
                $error_trace_result .= "{$value['no']}. [file] {$value['file']} [line] {$value['line']} [function] {$value['function']}" . $this->eol;
            }
            $error_trace_result .= "------ end Stack Trace ------" . $this->eol;
        }

        return $error_trace_result;
    }
}
