<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterParameter.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * パラメータからフレームワーク遷移値を取得するクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterParameter.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_RouterParameter extends SyL_Router
{
    /**
     * アクションの区切り文字
     *
     * @access protected
     * @var string
     */
    var $action_delimiter = '.';
    /**
     * メソッドの区切り文字
     *
     * @access protected
     * @var string
     */
    var $method_delimiter = ':';

    /**
     * 遷移情報オブジェクトのプロパティを作成
     *
     * @access public
     * @param object データ管理オブジェクト
     */
    function createActionInfo(&$data)
    {
        $this->setRouterInfo($data->geta(SYL_ACTION_KEY, 0));
    }

    /**
     * 遷移情報オブジェクトのプロパティを作成
     *
     * @access protected
     * @param string アクション名
     */
    function setRouterInfo($action)
    {
        if ($action === null) {
            $this->action_method = '';
            $this->action_file = $this->action_file_default;
        } else {
            $actions_path = explode($this->action_delimiter, $action);
            $method   = explode($this->method_delimiter, $actions_path[count($actions_path)-1], 2);

            $this->action_method = (count($method) == 2) ? ucfirst($method[1]) : $this->action_method;
            array_pop($actions_path);
            $action_dir = implode('/', array_map('ucfirst', $actions_path));
            if ($action_dir) {
                $this->action_file = $action_dir . '/' . ucfirst($method[0]) . $this->exe_ext;
            } else {
                $this->action_file = ucfirst($method[0]) . $this->exe_ext;
            }
        }

        // テンプレートファイル
        $this->setTemplateFile(substr($this->action_file, 0, intval('-' . strlen($this->exe_ext))) . SYL_ROUTER_URL_EXT);
        // オリジナルアクションファイル
        $this->action_file_org = $this->action_file;
    }
}
