<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Loggers.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ログ出力クラス
 */
require_once 'SyL_Logger.php';

/**
 * ログ出力カテゴリクラスを複数保持するクラス
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Loggers.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_Loggers
{
    /**
     * ログカテゴリオブジェクト格納配列
     * 
     * @access private
     * @var array
     */
    var $loggers = array();
    /**
     * ログレベル格納配列
     * 
     * @access private
     * @var array
     */
    var $modes = array();

    /**
     * SyL_Loggersクラスのインスタンス取得
     *
     * @access public
     * @return object SyL_Loggersオブジェクト
     */
    function &singleton()
    {
        static $singleton;
        if (!is_object($singleton)) {
            $singleton = new SyL_Loggers();
        }
        return $singleton;
    }

    /**
     * ログオブジェクトのセット
     * 
     * @access public
     * @param object ログオブジェクト
     * @param int ログレベル
     */
    function setLogger(&$logger, $mode=SYL_LOG)
    {
        if (($mode > SYL_LOG_NONE) && $logger) {
            $this->loggers[] =& $logger;
            $this->modes[]   =  $mode;
        }
    }

    /**
     * ログの出力（ERROR）
     *
     * @access public
     * @param string メッセージ
     */
    function error($message)
    {
        $log =& SyL_Loggers::singleton();
        foreach (array_keys($log->loggers) as $key) {
            if ($log->modes[$key] >= SYL_LOG_ERROR) {
                $log->loggers[$key]->log('error', $log->formatLog($message));
            }
        }
    }

    /**
     * ログの出力（WARN）
     *
     * @access public
     * @param string メッセージ
     */
    function warn($message)
    {
        $log =& SyL_Loggers::singleton();
        foreach (array_keys($log->loggers) as $key) {
            if ($log->modes[$key] >= SYL_LOG_WARN) {
                $log->loggers[$key]->log('warn', $log->formatLog($message));
            }
        }
    }

    /**
     * ログの出力（NOTICE）
     *
     * @access public
     * @param string メッセージ
     */
    function notice($message)
    {
        $log =& SyL_Loggers::singleton();
        foreach (array_keys($log->loggers) as $key) {
            if ($log->modes[$key] >= SYL_LOG_NOTICE) {
                $log->loggers[$key]->log('notice', $log->formatLog($message));
            }
        }
    }

    /**
     * ログの出力（INFO）
     *
     * @access public
     * @param string メッセージ
     */
    function info($message)
    {
        $log =& SyL_Loggers::singleton();
        foreach (array_keys($log->loggers) as $key) {
            if ($log->modes[$key] >= SYL_LOG_INFO) {
                $log->loggers[$key]->log('info', $log->formatLog($message));
            }
        }
    }

    /**
     * ログの出力（DEBUG）
     *
     * @access public
     * @param string メッセージ
     */
    function debug($message)
    {
        $log =& SyL_Loggers::singleton();
        foreach (array_keys($log->loggers) as $key) {
            if ($log->modes[$key] >= SYL_LOG_DEBUG) {
                $log->loggers[$key]->log('debug', $log->formatLog($message));
            }
        }
    }

    /**
     * 後処理
     *
     * @access public
     */
    function close()
    {
        foreach (array_keys($this->loggers) as $key) {
            $this->loggers[$key]->close();
        }
    }

    /**
     * ログ情報を型によって内容を変更する
     *
     * @access private
     * @param mixed ログ情報
     * @return string ログ情報
     */
    function formatLog($message)
    {
        if (is_scalar($message)) {
            if (is_bool($message)) {
                return $message ? 'true' : 'false';
            } else {
                return (string)$message;
            }
        } else {
            return print_r($message, true);
        }
    }
}
