<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_HttpClient.php,v 1.2 2009/02/14 04:32:56 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ソケットクラス
 */
require_once dirname(__FILE__) . '/../SyL_Socket.php';
/**
 * HTTPクライアントリクエストクラス
 */
require_once 'SyL_HttpClientRequest.php';
/**
 * HTTPクライアントレスポンスクラス
 */
require_once 'SyL_HttpClientResponse.php';

/**
 * HTTPクライアントクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_HttpClient.php,v 1.2 2009/02/14 04:32:56 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_HttpClient
{
    /**
     * リクエスト対象ホスト名
     * 
     * @access private
     * @var string
     */
    var $host = '';
    /**
     * リクエスト対象ポート番号
     * 
     * @access private
     * @var int
     */
    var $port = 80;
    /**
     * SSL使用判定
     * 
     * @access private
     * @var bool
     */
    var $ssl = false;
    /**
     * タイムアウト [s]
     *
     * var int
     */
    var $timeout = 5;
    /**
     * エラーメッセージ
     * 
     * @access private
     * @var string
     */
    var $error_message = '';
    /**
     * リクエストトレースメソッド
     * 
     * @access private
     * @var mixed
     */
    var $callback_trace = null;

    /**
     * コンストラクタ
     * 
     * @access public
     * @param string リクエスト対象ホスト名
     * @param int リクエスト対象ポート番号
     * @param bool SSL使用判定
     */
    function SyL_HttpClient($host, $port=80, $ssl=false)
    {
      $this->host = $host;
      $this->port = $port;
      $this->ssl  = $ssl;
      // デフォルトコールバックメソッド
      $this->callback_trace = array(&$this, 'trace');
    }

    /**
     * パラメータオブジェクトを取得する
     * 
     * @access protected
     * @param string リクエストURL
     * @param string リクエストメソッド
     */
    function &createRequest($url='/', $method='GET')
    {
        $request =& new SyL_HttpClientRequest($url, $method);
        return $request;
    }

    /**
     * エラー判定
     * 
     * @access public
     * @return bool true: エラーあり。false: エラー無し
     */
    function isError()
    {
        return ($this->error_message ? true : false);
    }

    /**
     * エラーメッセージを取得
     * 
     * @access public
     * @return string エラーメッセージ
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }

    /**
     * リクエストを送信して、レスポンスオブジェクトを取得
     * 
     * @access public
     * @param object リクエストパラメータオブジェクト
     * @param string クライアントエンコード
     */
    function &sendRequest(&$request, $client_encode='')
    {
        // ホストヘッダ用セット
        if (!$request->isHeader('host') && !preg_match('/^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/', $this->host)) {
            $request->setHeader('host', $this->host);
        }

        $host = ($this->ssl) ? 'ssl://' . $this->host : $this->host;
        $socket = new SyL_Socket($host, $this->port);
        $socket->setCommandCallBackFunc($this->callback_trace);

        if (!$socket->open($this->timeout)) {
            $this->error_message = $socket->getLastError();
            return false;
        }

        if (!$socket->send($request->getSource())) {
            $this->error_message = $socket->getLastError();
            return false;
        }

        $data = $socket->receiveAll(true);
        $socket->close();

        return $this->createResponse($data, $client_encode);
    }

    /**
     * 結果オブジェクトを取得する
     * 
     * @access protected
     * @param string レスポンスデータ
     * @param string クライアントエンコード
     */
    function &createResponse(&$data, $client_encode='')
    {
        $response =& new SyL_HttpClientResponse($data, $client_encode);
        return $response;
    }

    /**
     * レスポンスコールバックメソッド
     * 
     * @access public
     * @param string send or recieve
     * @param string メッセージ
     */
    function trace($type, $message)
    {
    }
}
