<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSendDefault.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * メール関数送信クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSendDefault.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_MailSendDefault extends SyL_MailSend
{
    /**
     * メール送信実行
     *
     * @access public
     * @param object メールメッセージオブジェクト
     * @return OK: true, NG: false
     */
    function send($message)
    {
        $from = $message->getFrom();
        $to   = $message->getTo();

        $additional_parameters = null;
        if (count($from) > 0) {
            // リターンパスのセット
            $additional_parameters = ' -f' . $from[0];
        } else {
            $this->error_message = "[SyL error] From Address not found";
            return false;
        }
        if (count($to) == 0) {
            $this->error_message = "[SyL error] To Address not found";
            return false;
        }

        // メール送信実行
        if (!mail(null, $message->convertEncoding($message->getSubject(), true), null, $message->getMessage(), $additional_parameters)) {
            $this->error_message = "[SyL error] mail function error";
            return false;
        }

        return true;
    }
}
