<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Mail.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * メールメッセージクラス
 */
require_once dirname(__FILE__) . '/Mail/SyL_MailMessage.php';

/**
 * メールクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Mail.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_Mail
{
    /**
     * メールサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'localhost';
    /**
     * メールサーバーのポート
     *
     * @access protected
     * @var int
     */
    var $port = '';
    /**
     * ユーザー名
     *
     * @access protected
     * @var string
     */
    var $user = '';
    /**
     * パスワード
     *
     * @access protected
     * @var string
     */
    var $passwd = '';
    /**
     * メール内容のエンコード
     * 
     * @access protected
     * @var string
     */
    var $mail_encode = 'ISO-2022-JP';
    /**
     * プログラム側のエンコード
     * 
     * @access protected
     * @var string
     */
    var $internal_encode = '';
    /**
     * 言語
     * 
     * @access protected
     * @var string
     */
    var $language = 'ja';
    /**
     * エラーメッセージ
     * 
     * @access protected
     * @var string
     */
    var $error_message = '';

    /**
     * コンストラクタ
     * 
     * @access public
     */
    function SyL_Mail()
    {
        $language = mb_language();
        if ($language) {
            $this->language = $language;
        }
        $this->internal_encode = mb_internal_encoding();
    }

    /**
     * メール送信クラスのインスタンス取得
     *
     * @static
     * @access public
     * @param string メール送信タイプ
     * @return object メール送信オブジェクト
     */
    function &factorySend($mail_string='default')
    {
        include_once dirname(__FILE__) . '/Mail/SyL_MailSend.php';

        $mail_strings = explode(':', $mail_string, 2);
        $class_name = 'SyL_MailSend' . ucfirst($mail_strings[0]);
        include_once dirname(__FILE__) . '/Mail/Send/' . $class_name . '.php';
        $mail = new $class_name();
        if (isset($mail_strings[1])) {
            foreach (explode(';', $mail_strings[1]) as $tmp) {
                if (strpos($tmp, '=') !== false) {
                    list($method, $value) = explode('=', $tmp, 2);
                    $method = 'set' . ucfirst($method);
                    $mail->$method($value);
                }
            }
        }
        return $mail;
    }

    /**
     * メール受信クラスのインスタンス取得
     *
     * @static
     * @access public
     * @param string メール受信タイプ
     * @return object メール受信オブジェクト
     */
    function &factoryReceive($mail_string='Pop3')
    {
        include_once dirname(__FILE__) . '/Mail/SyL_MailReceive.php';

        $mail_strings = explode(':', $mail_string, 2);
        $class_name = 'SyL_MailReceive' . ucfirst($mail_strings[0]);
        include_once dirname(__FILE__) . '/Mail/Receive/' . $class_name . '.php';
        $mail = new $class_name();
        if (isset($mail_strings[1])) {
            foreach (explode(';', $mail_strings[1]) as $tmp) {
                if (strpos($tmp, '=') !== false) {
                    list($method, $value) = explode('=', $tmp, 2);
                    $method = 'set' . ucfirst($method);
                    $mail->$method($value);
                }
            }
        }
        return $mail;
    }

    /**
     * メールメッセージオブジェクトを作成する
     * 
     * @access public
     * @return object メールメッセージオブジェクト
     */
    function &createMessage()
    {
        $message =& new SyL_MailMessage();
        $message->setMailEncode($this->mail_encode);
        $message->setInternalEncode($this->internal_encode);
        $message->setLanguage($this->language);
        return $message;
    }

    /**
     * ホスト名をセットする
     *
     * @access public
     * @param string ホスト名
     */
    function setHost($host)
    {
        $this->host = $host;
    }

    /**
     * ポート番号をセットする
     *
     * @access public
     * @param string ポート番号
     */
    function setPort($port)
    {
        $this->port = $port;
    }

    /**
     * ユーザー名をセットする
     *
     * @access public
     * @param string ユーザー名
     */
    function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * パスワードをセットする
     *
     * @access public
     * @param string パスワード
     */
    function setPasswd($passwd)
    {
        $this->passwd = $passwd;
    }

    /**
     * メールエンコードをセットする
     *
     * @access public
     * @param string メールエンコード
     */
    function setMailEncode($mail_encode)
    {
        $this->mail_encode = $mail_encode;
    }

    /**
     * 内部パラメータエンコードをセットする
     *
     * @access public
     * @param string 内部パラメータエンコード
     */
    function setInternalEncode($internal_encode)
    {
        $this->internal_encode = $internal_encode;
    }

    /**
     * 言語をセットする
     *
     * @access public
     * @param string 言語
     */
    function setLanguage($language)
    {
        $this->language = $language;
    }

    /**
     * エラーメッセージ判定
     *
     * @access public
     * @return string エラーメッセージ
     */
    function isError()
    {
        return ($this->error_message != '');
    }

    /**
     * エラーメッセージを取得する
     *
     * @access public
     * @return string エラーメッセージ
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }
}
