<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_TemplateXslt.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XSLT 適用クラス
 */
require_once dirname(__FILE__) . '/../Xml/SyL_XmlXslt.php';

/** 
 * XSLT テンプレートクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_TemplateXslt.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_TemplateXslt extends SyL_Template
{
    /**
     * XMLファイル
     *
     * @access private
     * @var string
     */
    var $xml_file = '';

    /**
     * XMLファイルをセットする
     *
     * @access public
     * @param string XMLファイル
     */
    function setXmlFile($xml_file)
    {
        $this->xml_file = $xml_file;
    }

    /**
     * テンプレートを適用する
     *
     * @access public
     * @return string テンプレート適用後データ
     */
    function render()
    {
        $xslt =& new SyL_XmlXslt($this->template_file, $this->xml_file);
        if (!$this->xml_file) {
            $xslt->setXml('<?xml version="1.0" encoding="UTF-8"?><root></root>', true);
        }

        $xslt->sets($this->gets());
        $xslt->sets($this->renderChild());
        return $xslt->transform();
    }
}
