<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilRemoteHost3web_ne_jp.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * リモートホスト判定クラス (3web.ne.jp)
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilRemoteHost3web_ne_jp.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_UtilRemoteHost3web_ne_jp extends SyL_UtilRemoteHost
{
    /**
     * ドメイン
     *
     * @access protected
     * @var string
     */
    var $domain = '3web.ne.jp';
    /**
     * プロバイダ名
     *
     * @access protected
     * @var string
     */
    var $provider = '3WEB';
    /**
     * プロバイダURL
     *
     * @access protected
     * @var string
     */
    var $url = 'http://www.gmo-isp.com/';
    /**
     * 運営会社名
     *
     * @access protected
     * @var string
     */
    var $company = 'GMOインターネット株式会社';

    /**
     * 都道府県判定用配列
     *
     * @access protected
     * @var array
     */
    var $prefectures = array(
      'tky.' => '13',
      'ngy.' => '23',
      'osk.' => '27'
    );
}
