<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilRemoteHostOcn_ne_jp.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * リモートホスト判定クラス (ocn.ne.jp)
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilRemoteHostOcn_ne_jp.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_UtilRemoteHostOcn_ne_jp extends SyL_UtilRemoteHost
{
    /**
     * ドメイン
     *
     * @access protected
     * @var string
     */
    var $domain = 'ocn.ne.jp';
    /**
     * プロバイダ名
     *
     * @access protected
     * @var string
     */
    var $provider = 'OCN';
    /**
     * プロバイダURL
     *
     * @access protected
     * @var string
     */
    var $url = 'http://www.ocn.ne.jp/';
    /**
     * 運営会社名
     *
     * @access protected
     * @var string
     */
    var $company = 'エヌ・ティ・ティ・コミュニケーションズ株式会社';

    /**
     * 都道府県判定用配列
     *
     * @access protected
     * @var array
     */
    var $prefectures = array(
      '.hokkaido.'  => '01',
      '.aomori.'    => '02',
      '.iwate.'     => '03',
      '.miyagi.'    => '04',
      '.akita.'     => '05',
      '.yamagata.'  => '06',
      '.fukushima.' => '07',
      '.ibaraki.'   => '08',
      '.tochigi.'   => '09',
      '.gunma.'     => '10',
      '.saitama.'   => '11',
      '.chiba.'     => '12',
      '.tokyo.'     => '13',
      '.kanagawa.'  => '14',
      '.niigata.'   => '15',
      '.toyama.'    => '16',
      '.ishikawa.'  => '17',
      '.fukui.'     => '18',
      '.yamanashi.' => '19',
      '.nagano.'    => '20',
      '.gifu.'      => '21',
      '.shizuoka.'  => '22',
      '.aichi.'     => '23',
      '.mie.'       => '24',
      '.shiga.'     => '25',
      '.kyoto.'     => '26',
      '.osaka.'     => '27',
      '.hyogo.'     => '28',
      '.nara.'      => '29',
      '.wakayama.'  => '30',
      '.tottori.'   => '31',
      '.shimane.'   => '32',
      '.okayama.'   => '33',
      '.hiroshima.' => '34',
      '.yamaguchi.' => '35',
      '.tokushima.' => '36',
      '.kagawa.'    => '37',
      '.ehime.'     => '38',
      '.kochi.'     => '39',
      '.fukuoka.'   => '40',
      '.saga.'      => '41',
      '.nagasaki.'  => '42',
      '.kumamoto.'  => '43',
      '.oita.'      => '44',
      '.miyazaki.'  => '45',
      '.kagoshima.' => '46',
      '.okinawa.'   => '47'
    );

    /**
     * 回線種別判定用配列
     *
     * @access protected
     * @var array
     */
    var $connection_type = array(
      '-ipad'  => 'adsl-ntt',
      '-ipbf'  => 'opt-ntt',
      '-adsa'  => 'adsl-acca',
      '-ipdng' => 'dialup',
      '-ip'    => 'isdn-ntt'
    );
}
