<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceZipsearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（郵便番号検索API用）
 *
 * 詳細は、Web サービス参照
 *   http://groovetechnology.co.jp/webservice/index.html
 * 郵便番号検索API
 *   http://groovetechnology.co.jp/webservice/zipsearch/index.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceZipsearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceZipsearchResponse extends SyL_WebServiceGroovetechnology_co_jpResponse
{
    /**
     * 住所の郵便番号情報
     *
     * @access private
     * @var array
     */
    var $addresses = array();
    /**
     * 事業所の個別郵便番号情報
     *
     * @access private
     * @var array
     */
    var $offices = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $a_i = -1;
        static $o_i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 住所の郵便番号の情報
        case '/groovewebservice/address': $a_i++; break;
        // 郵便番号
        case '/groovewebservice/address/zipcode': $this->addresses[$a_i]['zipcode'] = $text; break;
        // 都道府県名
        case '/groovewebservice/address/prefecture': $this->addresses[$a_i]['prefecture'] = $text; break;
        // 市区町村名
        case '/groovewebservice/address/city': $this->addresses[$a_i]['city'] = $text; break;
        // 町域名
        case '/groovewebservice/address/town': $this->addresses[$a_i]['town'] = $text; break;
        // 大口事業所等名
        case '/groovewebservice/address/office_name': $this->addresses[$a_i]['office_name'] = $text; break;
        // 大口事業所等名の小字名、丁目、番地等
        case '/groovewebservice/address/street': $this->addresses[$a_i]['street'] = $text; break;
        // 都道府県名のよみ（カタカナ）
        case '/groovewebservice/address/prefecture_yomi': $this->addresses[$a_i]['prefecture_yomi'] = $text; break;
        // 市区町村名のよみ（カタカナ）
        case '/groovewebservice/address/city_yomi': $this->addresses[$a_i]['city_yomi'] = $text; break;
        // 町域名のよみ（カタカナ）
        case '/groovewebservice/address/town_yomi': $this->addresses[$a_i]['town_yomi'] = $text; break;
        // 大口事業所等名のよみ（カタカナ）
        case '/groovewebservice/address/office_name_yomi': $this->addresses[$a_i]['town_yomi'] = $text; break;

        // 事業所の個別郵便番号の情報
        case '/groovewebservice/office': $o_i++; break;
        // 郵便番号
        case '/groovewebservice/office/zipcode': $this->offices[$o_i]['zipcode'] = $text; break;
        // 都道府県名
        case '/groovewebservice/office/prefecture': $this->offices[$o_i]['prefecture'] = $text; break;
        // 市区町村名
        case '/groovewebservice/office/city': $this->offices[$o_i]['city'] = $text; break;
        // 町域名
        case '/groovewebservice/office/town': $this->offices[$o_i]['town'] = $text; break;
        // 大口事業所等名
        case '/groovewebservice/office/office_name': $this->offices[$o_i]['office_name'] = $text; break;
        // 大口事業所等名の小字名、丁目、番地等
        case '/groovewebservice/office/street': $this->offices[$o_i]['street'] = $text; break;
        // 都道府県名のよみ（カタカナ）
        case '/groovewebservice/office/prefecture_yomi': $this->offices[$o_i]['prefecture_yomi'] = $text; break;
        // 市区町村名のよみ（カタカナ）
        case '/groovewebservice/office/city_yomi': $this->offices[$o_i]['city_yomi'] = $text; break;
        // 町域名のよみ（カタカナ）
        case '/groovewebservice/office/town_yomi': $this->offices[$o_i]['town_yomi'] = $text; break;
        // 大口事業所等名のよみ（カタカナ）
        case '/groovewebservice/office/office_name_yomi': $this->offices[$o_i]['town_yomi'] = $text; break;

        }
    }

    /**
     * 住所の郵便番号情報を取得する
     *
     * @access public
     * @return array 住所の郵便番号情報
     */
    function getAddresses()
    {
        return $this->addresses;
    }

    /**
     * 事業所の個別郵便番号情報を取得する
     *
     * @access public
     * @return array 事業所の個別郵便番号情報
     */
    function getOffices()
    {
        return $this->offices;
    }
}
