<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionAuctionItemSearchResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天オークション商品検索API用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天オークション商品検索API
 *   http://webservice.rakuten.co.jp/api/auctionitemsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionAuctionItemSearchResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceAuctionAuctionItemSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 検索数
     *
     * @access private
     * @var int
     */
    var $count = 0;
    /**
     * ページ番号
     *
     * @access private
     * @var int
     */
    var $page = 0;
    /**
     * ページ内商品始追番
     *
     * @access private
     * @var int
     */
    var $first = 0;
    /**
     * ページ内商品終追番
     *
     * @access private
     * @var int
     */
    var $last = 0;
    /**
     * ヒット件数
     *
     * @access private
     * @var int
     */
    var $hits = 0;
    /**
     * キャリア情報
     *
     * @access private
     * @var int
     */
    var $carrier = 0;
    /**
     * 総ページ数
     *
     * @access private
     * @var int
     */
    var $page_count = 0;
    /**
     * 商品情報
     *
     * @access private
     * @var array
     */
    var $items = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 検索数
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/count': $this->count = $text; break;
        // ページ番号
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/page': $this->page = $text; break;
        // ページ内商品始追番
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/first': $this->first = $text; break;
        // ページ内商品終追番
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/last': $this->last = $text; break;
        // ヒット件数
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/hits': $this->hits = $text; break;
        // キャリア情報
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/carrier': $this->carrier = $text; break;
        // 総ページ数
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/pageCount': $this->page_count = $text; break;

        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item': $i++; break;
        // 商品名
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/itemName': $this->items[$i]['itemName'] = $text; break;
        // オークション商品コード
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/itemCode': $this->items[$i]['itemCode'] = $text; break;
        // 出品商品現在価格
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/itemPrice': $this->items[$i]['itemPrice'] = $text; break;
        // 最低入札価格
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/minPrice': $this->items[$i]['minPrice'] = $text; break;
        // 商品説明分
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/itemCaption': $this->items[$i]['itemCaption'] = $text; break;
        // 商品URL
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/itemUrl': $this->items[$i]['itemUrl'] = $text; break;
        // アフィリエイトURL
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/affiliateUrl': $this->items[$i]['affiliateUrl'] = $text; break;
        // 商品画像有無フラグ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/imageFlag': $this->items[$i]['imageFlag'] = $text; break;
        // 商品画像64x64URL
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/smallImageUrl': $this->items[$i]['smallImageUrl'] = $text; break;
        // 商品画像128x128URL
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/mediumImageUrl': $this->items[$i]['mediumImageUrl'] = $text; break;

        // 即落フラグ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/blowFlag': $this->items[$i]['blowFlag'] = $text; break;
        // 結果フラグ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/resultFlag': $this->items[$i]['resultFlag'] = $text; break;
        // 入札件数
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/bidCount': $this->items[$i]['bidCount'] = $text; break;
        // 消費税フラグ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/taxFlag': $this->items[$i]['taxFlag'] = $text; break;
        // 送料フラグ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/postageFlag': $this->items[$i]['postageFlag'] = $text; break;
        // クレジットカード利用可能フラグ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/creditCardFlag': $this->items[$i]['creditCardFlag'] = $text; break;
        // アフィリエイト利用利率
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/affiliateRate': $this->items[$i]['affiliateRate'] = $text; break;
        // 販売開始時刻
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/startTime': $this->items[$i]['startTime'] = $text; break;
        // 販売終了時刻
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/endTime': $this->items[$i]['endTime'] = $text; break;
        // 出品者名
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/shopName': $this->items[$i]['shopName'] = $text; break;
        // 出品者種別フラグ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/shopStatusFlag': $this->items[$i]['shopStatusFlag'] = $text; break;
        // ジャンルID
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/genreId': $this->items[$i]['genreId'] = $text; break;

        // 上記以外
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 検索数を取得する
     *
     * @access public
     * @return int 検索数
     */
    function getCount()
    {
        return $this->count;
    }

    /**
     * ページ番号を取得する
     *
     * @access public
     * @return int 検索数
     */
    function getPage()
    {
        return $this->page;
    }

    /**
     * ページ内商品始追番を取得する
     *
     * @access public
     * @return int 検索数
     */
    function getFirst()
    {
        return $this->first;
    }

    /**
     * ページ内商品終追番を取得する
     *
     * @access public
     * @return int 検索数
     */
    function getLast()
    {
        return $this->last;
    }

    /**
     * キャリア情報を取得する
     *
     * @access public
     * @return int 検索数
     */
    function getCarrier()
    {
        return $this->carrier;
    }

    /**
     * 総ページ数を取得する
     *
     * @access public
     * @return int 検索数
     */
    function getPageCount()
    {
        return $this->page_count;
    }

    /**
     * 商品情報を取得する
     *
     * @access public
     * @return array 商品情報
     */
    function getItems()
    {
        return $this->items;
    }

}
