<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceRakuten_co_jpRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスリクエストクラス（楽天）
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceRakuten_co_jpRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceRakuten_co_jpRequest extends SyL_WebServiceRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'api.rakuten.co.jp';

    /**
     * デベロッパIDをセットする
     *
     * @access public
     * @param string デベロッパID
     */
    function setDeveloperId($developerId)
    {
        parent::set('developerId', $developerId);
    }

    /**
     * アフィリエイトIDをセットする
     *
     * @access public
     * @param string アフィリエイトID
     */
    function setAffiliateId($affiliateId)
    {
        parent::set('affiliateId', $affiliateId);
    }

    /**
     * 使用するAPIの操作名をセットする
     *
     * @access public
     * @param string 使用するAPIの操作名
     */
    function setOperation($operation)
    {
        parent::set('operation', $operation);
    }

    /**
     * コールバック関数名をセットする
     *
     * @access public
     * @param string コールバック関数名
     */
    function setCallBack($callBack)
    {
        if (preg_match('/^[0-9a-zA-Z_\.\[\]]+$/', $callBack)) {
            parent::set('callBack', $callBack);
        } else {
            trigger_error("[SyL error] Invalid `callBack' property ({$callBack}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
