<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceRakuten_co_jpResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天）
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceRakuten_co_jpResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceRakuten_co_jpResponse extends SyL_WebServiceResponse
{
    /**
     * ステータス名
     *
     * @access private
     * @var string
     */
    var $status = '';
    /**
     * ステータスメッセージ
     *
     * @access private
     * @var string
     */
    var $status_message = '';
    /**
     * 引数配列
     *
     * @access private
     * @var array
     */
    var $args = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        switch ($current_path) {
        // =============================
        // 共通ヘッダー系
        // =============================
        case '/Response/header:Header/Args/Arg':  $this->args[$attribute['key']] = $attribute['value']; break;
        case '/Response/header:Header/Status':    $this->status = $text; break;
        case '/Response/header:Header/StatusMsg': $this->status_message = $text; break;

        case '/Response/Header/Args/Arg':  $this->args[$attribute['key']] = $attribute['value']; break;
        case '/Response/Header/Status':    $this->status = $text; break;
        case '/Response/Header/StatusMsg': $this->status_message = $text; break;
        }
    }

    /**
     * 引数を取得する
     *
     * @access public
     * @param string 引数キー
     * @reutrn mixed 引数値
     */
    function getArgs($arg=null)
    {
        if ($arg !== null) {
            return isset($this->args[$arg]) ? $this->args[$arg] : null;
        } else {
            return $this->args;
        }
    }

    /**
     * エラー判定を行う
     *
     * @access public
     * @reutrn bool エラー判定
     */
    function isError()
    {
        return ($this->status != 'Success');
    }

    /**
     * ステータス名を取得する
     *
     * @access public
     * @reutrn string ステータス名
     */
    function getStatus()
    {
        return $this->status;
    }

    /**
     * ステータスメッセージを取得する
     *
     * @access public
     * @reutrn string ステータスメッセージ
     */
    function getStatusMessage()
    {
        return $this->status_message;
    }
}
