<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelKeywordHotelSearchRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天トラベル施設検索API用）
 */
require_once 'SyL_WebServiceTravelKeywordHotelSearchResponse.php';

/**
 * WEBサービスクラス（楽天 - 楽天トラベル施設検索API用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天トラベル施設検索API 
 *   http://webservice.rakuten.co.jp/api/KeywordHotelSearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelKeywordHotelSearchRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceTravelKeywordHotelSearchRequest extends SyL_WebServiceRakuten_co_jpRequest
{
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/rws/1.11/rest';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceTravelKeywordHotelSearchResponse';

    /**
     * バージョンをセットする
     *
     * @access public
     * @param string バージョン
     */
    function setVersion($version)
    {
        parent::set('version', $version);
    }

    /**
     * キャリア情報をセットする
     *
     * @access public
     * @param int キャリア情報
     */
    function setCarrier($carrier)
    {
        switch ((string)$carrier) {
        case '0':
        case '1':
            parent::set('carrier', $carrier);
            break;
        default:
            trigger_error("[SyL error] Invalid `carrier' property ({$carrier}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 取得ページをセットする
     *
     * @access public
     * @param int 取得ページ
     */
    function setPage($page)
    {
        if (preg_match('/^\d+$/', $page)) {
            parent::set('page', $page);
        } else {
            trigger_error("[SyL error] Invalid `page' property ({$page}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 1ページあたりの取得件数をセットする
     *
     * @access public
     * @param int 1ページあたりの取得件数
     */
    function setHits($hits)
    {
        if (preg_match('/^\d+$/', $hits) && (($hits >= 1) && ($hits <= 100))) {
            parent::set('hits', $hits);
        } else {
            trigger_error("[SyL error] Invalid `hits' property ({$hits}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 要約表示フラグをセットする
     *
     * @access public
     * @param int 要約表示フラグ
     */
    function setSumDisplayFlag($sumDisplayFlag)
    {
        switch ((string)$sumDisplayFlag) {
        case '0':
        case '1':
            parent::set('sumDisplayFlag', $sumDisplayFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `sumDisplayFlag' property ({$sumDisplayFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 検索キーワードをセットする
     *
     * @access public
     * @param string 検索キーワード
     */
    function setKeyword($keyword)
    {
        parent::set('keyword', $keyword);
    }

    /**
     * 中区分コードをセットする
     *
     * @access public
     * @param string 中区分コード
     */
    function setMiddleClassCode($middleClassCode)
    {
        parent::set('middleClassCode', $middleClassCode);
    }
}
