<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelVacantHotelSearchResponse.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天トラベル空室検索API用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天トラベル空室検索API  
 *   http://webservice.rakuten.co.jp/api/vacanthotelsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelVacantHotelSearchResponse.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceTravelVacantHotelSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 部屋情報
     *
     * @access private
     * @var array
     */
    var $rooms = array();
    /**
     * 施設情報
     *
     * @access private
     * @var array
     */
    var $hotels = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;
        static $j = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room': $i++; break;
        // 施設番号
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/hotelNo': $this->rooms[$i]['hotelNo'] = $text; break;
        // 部屋種別
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/roomClass': $this->rooms[$i]['roomClass'] = $text; break;
        // 部屋名称
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/roomName': $this->rooms[$i]['roomName'] = $text; break;
        // プランID
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/planId': $this->rooms[$i]['planId'] = $text; break;
        // プラン名称
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/planName': $this->rooms[$i]['planName'] = $text; break;
        // プラン内容
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/planContents': $this->rooms[$i]['planContents'] = $text; break;
        // 楽天ポイント付与率
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/pointRate': $this->rooms[$i]['pointRate'] = $text; break;
        // 夕食有無フラグ
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/withDinnerFlag': $this->rooms[$i]['withDinnerFlag'] = $text; break;
        // 夕食選択フラグ
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/dinnerSelectFlag': $this->rooms[$i]['dinnerSelectFlag'] = $text; break;
        // 朝食有無フラグ
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/withBreakfastFlag': $this->rooms[$i]['withBreakfastFlag'] = $text; break;
        // 朝食選択フラグ
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/breakfastSelectFlag': $this->rooms[$i]['breakfastSelectFlag'] = $text; break;
        // 決済方法
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/settleWay': $this->rooms[$i]['settleWay'] = $text; break;
        // 予約ページURL
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/reserveUrl': $this->rooms[$i]['reserveUrl'] = $text; break;
        // 予約ページアフィリエイトURL
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/reserveAffiliateUrl': $this->rooms[$i]['reserveAffiliateUrl'] = $text; break;

        // 料金情報
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/dailyCharge': $this->rooms[$i]['dailyCharge'] = array(); break;
        // 宿泊年月日
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/dailyCharge/stayDate': $this->rooms[$i]['dailyCharge']['stayDate'] = $text; break;
        // 通常料金
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/dailyCharge/regularCharge': $this->rooms[$i]['dailyCharge']['regularCharge'] = $text; break;
        // 楽天料金
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/room/dailyCharge/rakutenCharge': $this->rooms[$i]['dailyCharge']['rakutenCharge'] = $text; break;

        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel': $j++; break;
        // 施設番号
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/hotelNo': $this->hotels[$j]['hotelNo'] = $text; break;
        // 施設名称
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/hotelName': $this->hotels[$j]['hotelName'] = $text; break;
        // 施設かな名称
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/hotelKanaName': $this->hotels[$j]['hotelKanaName'] = $text; break;
        // 施設特色
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/hotelSpecial': $this->hotels[$j]['hotelSpecial'] = $text; break;
        // チェックイン時刻
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/checkinTime': $this->hotels[$j]['checkinTime'] = $text; break;
        // チェックアウト時刻
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/checkoutTime': $this->hotels[$j]['checkoutTime'] = $text; break;
        // 緯度
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/latitude': $this->hotels[$j]['latitude'] = $text; break;
        // 経度
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/longitude': $this->hotels[$j]['longitude'] = $text; break;
        // 郵便番号
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/postalCode': $this->hotels[$j]['postalCode'] = $text; break;
        // 住所１
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/address1': $this->hotels[$j]['address1'] = $text; break;
        // 住所２
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/address2': $this->hotels[$j]['address2'] = $text; break;
        // 施設電話番号
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/telephoneNo': $this->hotels[$j]['telephoneNo'] = $text; break;
        // ファックス番号
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/faxNo': $this->hotels[$j]['faxNo'] = $text; break;
        // 施設へのアクセス
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/access': $this->hotels[$j]['access'] = $text; break;
        // 最寄駅名称
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/nearestStationName': $this->hotels[$j]['nearestStationName'] = $text; break;
        // 駐車場情報
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/parkingInformation': $this->hotels[$j]['parkingInformation'] = $text; break;
        // ホテル種別コード
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/hotelClassCode': $this->hotels[$j]['hotelClassCode'] = $text; break;
        // レコード件数 (予約候補)
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/recordCount': $this->hotels[$j]['recordCount'] = $text; break;
        // 予約候補内最安値
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/lowestCharge': $this->hotels[$j]['lowestCharge'] = $text; break;
        // 予約候補内最高値
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/highestCharge': $this->hotels[$j]['highestCharge'] = $text; break;
        // 施設画像URL
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/hotelImageUrl': $this->hotels[$j]['hotelImageUrl'] = $text; break;
        // 施設情報ページURL
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/hotelInformationUrl': $this->hotels[$j]['hotelInformationUrl'] = $text; break;
        // 施設情報ページアフィリエイトURL
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/hotelAffiliateUrl': $this->hotels[$j]['hotelAffiliateUrl'] = $text; break;
        // 宿泊予約センター電話番号
        case '/Response/Body/vacantHotelSearch:VacantHotelSearch/hotel/reserveTelephoneNo': $this->hotels[$j]['reserveTelephoneNo'] = $text; break;

        // 上記以外
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 部屋情報を取得する
     *
     * @access public
     * @return array 部屋情報
     */
    function getRooms()
    {
        return $this->rooms;
    }

    /**
     * 施設情報を取得する
     *
     * @access public
     * @return array 施設情報
     */
    function getHotels()
    {
        return $this->hotels;
    }
}
