<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceRequest.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 汎用プロパティクラス
 */
require_once dirname(__FILE__) . '/../Util/SyL_UtilProperty.php';

/**
 * WEBサービスリクエストクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceRequest.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceRequest extends SyL_UtilProperty
{
    /**
     * リクエストタイプ
     *
     * @access protected
     * @var string
     */
    var $type = 'rest';
    /**
     * SSL
     *
     * @access protected
     * @var bool
     */
    var $ssl = false;
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = '';
    /**
     * WEBサービスサーバーのポート
     *
     * @access protected
     * @var string
     */
    var $port = '80';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = '';

    /**
     * コンストラクタ
     * 
     * @access public
     */
    function SyL_WebServiceRequest()
    {
    }

    /**
     * リクエストタイプを取得する
     *
     * @access public
     * @return string リクエストタイプ
     */
    function getRequestType()
    {
        return $this->type;
    }

    /**
     * SSLを有効か判定する
     *
     * @access public
     * @return bool SSLの有無
     */
    function isSsl()
    {
        return $this->ssl;
    }

    /**
     * リクエストホストを取得する
     *
     * @access public
     * @return string リクエストホスト
     */
    function getRequestHost()
    {
        return $this->host;
    }

    /**
     * リクエストポートを取得する
     *
     * @access public
     * @return string リクエストポート
     */
    function getRequestPort()
    {
        return $this->port;
    }

    /**
     * リクエストパスを取得する
     *
     * @access public
     * @return string リクエストパス
     */
    function getRequestPath()
    {
        return $this->path;
    }

    /**
     * レスポンスクラス名を取得する
     *
     * @access public
     * @return string レスポンスクラス名
     */
    function getResponseClass()
    {
        return $this->response_class;
    }
}
