<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceResponse.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML操作クラス
 */
require_once dirname(__FILE__) . '/../Xml/SyL_XmlReader.php';

/**
 * WEBサービスレスポンスクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceResponse.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceResponse extends SyL_XmlReader
{
    /**
     * エラー判定
     * 
     * @access protected
     * @var bool
     */
    var $error = false;
    /**
     * エラーメッセージ
     * 
     * @access protected
     * @var string
     */
    var $error_message = '';

    /**
     * コンストラクタ
     * 
     * @access public
     * @param string レスポンスステータス
     * @param string リクエスト結果XML
     * @param string サーバーエンコード
     * @param string クライアントエンコード
     */
    function SyL_WebServiceResponse($response_status, $result, $server_encode='UTF-8', $client_encode='')
    {
        if ($response_status != '200') {
            $this->error = true;
            $this->error_message = "status: {$response_status} ";
        }

        if ($server_encode) {
            $this->setXmlEncode($server_encode);
        }
        if ($client_encode) {
            $this->setClientEncode($client_encode);
        }
        $this->setData($result);
        $this->parseXml();
    }

    /**
     * XMLデータ内容取得ハンドラメソッド
     * ※オーバーライド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
    }

    /**
     * エラー判定
     *
     * @access public
     * @return bool true: エラーあり、false: エラーなし
     */
    function isError()
    {
        return $this->error;
    }

    /**
     * エラーメッセージを取得する
     *
     * @access public
     * @return string エラーメッセージ
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }
}
