<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionCategoryLeafResponse.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - オークション - 商品リスト用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * オークション - 商品リスト
 *   http://developer.yahoo.co.jp/auctions/rest/categoryleaf/V1/categoryleaf.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionCategoryLeafResponse.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceAuctionCategoryLeafResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 条件に一致した注目の商品（オークション）の総数データ内のマッチしたクエリー数
     *
     * @access private
     * @var int
     */
     var $total_f_auctions = null;
    /**
     * 条件に一致した商品（オークション）の総数 
     *
     * @access private
     * @var int
     */
    var $total_auctions = null;
    /**
     * 件に一致したページ総数
     *
     * @access private
     * @var int
     */
    var $total_page = null;
    /**
     * 現在のページ番号
     *
     * @access private
     * @var string
     */
    var $cur_page = null;
    /**
     * 商品リスト（カテゴリリーフ）のパス
     *
     * @access private
     * @var string
     */
    var $category_path = null;
    /**
     * 商品（オークション）情報
     *
     * @access private
     * @var array
     */
    var $items = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $item_i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/AuctionCategoryLeaf':
            if (isset($attribute['totalFAuctions'])) {
                $this->total_f_auctions = $attribute['totalFAuctions'];
            }
            if (isset($attribute['totalAuctions'])) {
                $this->total_auctions = $attribute['totalAuctions'];
            }
            if (isset($attribute['totalPage'])) {
                $this->total_page = $attribute['totalPage'];
            }
            if (isset($attribute['curPage'])) {
                $this->cur_page = $attribute['curPage'];
            }
            if (isset($attribute['categoryPath'])) {
                $this->category_path = $attribute['categoryPath'];
            }
            break;

        // 商品（オークション）情報
        case '/AuctionCategoryLeaf/item': $item_i++; break;
        // 商品（オークション）のID
        case '/AuctionCategoryLeaf/item/auctionID': $this->items[$item_i]['auctionID'] = $text; break;
        // 商品（オークション）のタイトル
        case '/AuctionCategoryLeaf/item/title': $this->items[$item_i]['title'] = $text; break;
        // 出品者に関する情報
        case '/AuctionCategoryLeaf/item/seller': $this->items[$item_i]['seller'] = array(); break;
        // 出品者のYahoo! JAPAN ID
        case '/AuctionCategoryLeaf/item/seller/id': $this->items[$item_i]['seller']['id'] = $text; break;
        // 出品リストを取得するリクエストURL
        case '/AuctionCategoryLeaf/item/seller/itemlist': $this->items[$item_i]['seller']['itemlist'] = $text; break;
        // 出品者の評価のページのURL
        case '/AuctionCategoryLeaf/item/seller/rating': $this->items[$item_i]['seller']['rating'] = $text; break;
        // 商品詳細（オークション）ページのURL
        case '/AuctionCategoryLeaf/item/url': $this->items[$item_i]['url'] = $text; break;
        // 画像（サムネイル）のURL
        case '/AuctionCategoryLeaf/item/img': $this->items[$item_i]['img'] = $text; break;
        // 現在価格
        case '/AuctionCategoryLeaf/item/price': $this->items[$item_i]['price'] = $text; break;
        // 現在の入札数
        case '/AuctionCategoryLeaf/item/bids': $this->items[$item_i]['bids'] = $text; break;
        // オークションの終了日時
        case '/AuctionCategoryLeaf/item/endtime': $this->items[$item_i]['endtime'] = $text; break;
        // 希望落札価格
        case '/AuctionCategoryLeaf/item/bidorbuy': $this->items[$item_i]['bidorbuy'] = $text; break;
        // 最低落札価格の有無
        case '/AuctionCategoryLeaf/item/reserved': $this->items[$item_i]['reserved'] = $text; break;
        // 商品（オークション）のオプション設定
        case '/AuctionCategoryLeaf/item/option': $this->items[$item_i]['option'] = array(); break;
        // 商品（オークション）のオプション設定: 「new」アイコンのURL
        case '/AuctionCategoryLeaf/item/option/new': $this->items[$item_i]['option']['new'] = $text; break;
        // 商品（オークション）のオプション設定: 「store」アイコンのURL
        case '/AuctionCategoryLeaf/item/option/store': $this->items[$item_i]['option']['store'] = $text; break;
        // 商品（オークション）のオプション設定: 「鑑定済み」アイコンのURL
        case '/AuctionCategoryLeaf/item/option/check': $this->items[$item_i]['option']['check'] = $text; break;
        // 商品（オークション）のオプション設定: 「公売」アイコンのURL
        case '/AuctionCategoryLeaf/item/option/public': $this->items[$item_i]['option']['public'] = $text; break;
        // 商品（オークション）のオプション設定: 「送料無料」アイコンのURL
        case '/AuctionCategoryLeaf/item/option/freeshipping': $this->items[$item_i]['option']['freeshipping'] = $text; break;
        // 商品（オークション）のオプション設定: 「受け取り後決済サービス」アイコンのURL
        case '/AuctionCategoryLeaf/item/option/escrow': $this->items[$item_i]['option']['escrow'] = $text; break;
        // 商品（オークション）のオプション設定: 「贈答品」アイコンのURL
        case '/AuctionCategoryLeaf/item/option/wrappingicon': $this->items[$item_i]['option']['wrappingicon'] = $text; break;
        // 商品（オークション）のオプション設定: 「即買」アイコンのURL
        case '/AuctionCategoryLeaf/item/option/buynow': $this->items[$item_i]['option']['buynow'] = $text; break;
        // 商品（オークション）のオプション設定: 「Yahoo!かんたん決済」アイコンのURL
        case '/AuctionCategoryLeaf/item/option/easypayment': $this->items[$item_i]['option']['easypayment'] = $text; break;
        // 商品（オークション）のオプション設定: 「特大画像」アイコンのURL
        case '/AuctionCategoryLeaf/item/option/largeimg': $this->items[$item_i]['option']['largeimg'] = $text; break;
        // 商品（オークション）のオプション設定: 「目立ち」アイコンのURL
        case '/AuctionCategoryLeaf/item/option/gift_icon': $this->items[$item_i]['option']['gift_icon'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 条件に一致した注目の商品（オークション）の総数データ内のマッチしたクエリー数を取得
     *
     * @access public
     * @return int 条件に一致した注目の商品（オークション）の総数データ内のマッチしたクエリー数
     */
    function getTotalFAuctions()
    {
        return $this->total_f_auctions;
    }

    /**
     * 条件に一致した商品（オークション）の総数を取得
     *
     * @access public
     * @return int 条件に一致した商品（オークション）の総数
     */
    function getTotalAuctions()
    {
        return $this->total_auctions;
    }

    /**
     * 条件に一致したページ総数を取得
     *
     * @access public
     * @return int 条件に一致したページ総数
     */
    function getTotalPage()
    {
        return $this->total_page;
    }

    /**
     * 現在のページ番号を取得
     *
     * @access public
     * @return int 現在のページ番号
     */
    function getCurPage()
    {
        return $this->cur_page;
    }

    /**
     * 商品リスト（カテゴリリーフ）のパスを取得
     *
     * @access public
     * @return string 商品リスト（カテゴリリーフ）のパス
     */
    function getCategoryPath()
    {
        return $this->category_path;
    }

    /**
     * 商品（オークション）情報を取得
     *
     * @access public
     * @return array 商品（オークション）情報
     */
    function getItems()
    {
        return $this->items;
    }
}
