<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategoryBrowseRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - ディレクトリツリー用）
 */
require_once 'SyL_WebServiceCategoryBrowseResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - ディレクトリツリー用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * ディレクトリツリー
 *   http://developer.yahoo.co.jp/category/browse/V1/browse.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategoryBrowseRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceCategoryBrowseRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'dir.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/Category/V1/Category';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceCategoryBrowseResponse';

    /**
     * カテゴリページのidをセットする
     *
     * @access public
     * @param int カテゴリページのid
     */
    function setId($id)
    {
        if (preg_match('/^\d+$/', $id)) {
            parent::set('id', $id);
        } else {
            trigger_error("[SyL error] Invalid `id' property ({$id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * カテゴリページのURLから「http://dir.yahoo.co.jp」を除いた部分をセットする
     *
     * @access public
     * @param string カテゴリページのURLから「http://dir.yahoo.co.jp」を除いた部分
     */
    function setPath($path)
    {
        parent::set('path', $path);
    }

    /**
     * カテゴリ取得区分をセットする
     *
     * @access public
     * @param int カテゴリ取得区分
     */
    function setType($type)
    {
        switch ((string)$type) {
        case '0': // カテゴリデータとサイトデータ。
        case '1': // カテゴリデータのみ。
        case '2': // サイトデータのみ。
            parent::set('type', $type);
            break;
        default:
            trigger_error("[SyL error] Invalid `type' property ($type) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * プロパゲートの有無をセットする
     *
     * @access public
     * @param int プロパゲートの有無
     */
    function setExpand($expand)
    {
        $expand = ($expand) ? '1' : '0';
        parent::set('expand', $expand);
    }
}
