<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategoryBrowseResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - ディレクトリツリー用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * ディレクトリツリー
 *   http://developer.yahoo.co.jp/category/browse/V1/browse.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategoryBrowseResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceCategoryBrowseResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * レスポンスの状態やサーバーからのメッセージ
     *
     * @access private
     * @var array
     */
     var $status = array();
    /**
     * カテゴリに関する情報
     *
     * @access private
     * @var array
     */
    var $space = array();
    /**
     * カテゴリItemの件数
     *
     * @access private
     * @var int
     */
    var $category_count = 0;
    /**
     * カテゴリからリンクしている下位カテゴリとショートカットカテゴリの集合
     *
     * @access private
     * @var array
     */
    var $category = array();
    /**
     * 登録されたサイトItemの件数
     *
     * @access private
     * @var int
     */
    var $site_count = 0;
    /**
     * Yahoo!カテゴリに登録されたサイト
     *
     * @access private
     * @var array
     */
    var $site = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $item_i = -1;
        static $site_i = -1;

        switch ($current_path) {
        // APIに渡されたパラメータの集合
        case '/CategoryResult/Status/Args/Arg': $this->status[$attribute['Name']] = $attribute['Value']; break;

        // =============================
        // エラー系
        // =============================
        // エラー判定
        case '/CategoryResult/Status/Errors': $this->error = true; break;
        case '/CategoryResult/Status/Errors/Error': $this->error_message .= $text; break;

        // =============================
        // 正常系
        // =============================
        // カテゴリのID
        case '/CategoryResult/Space/Id': $this->space['Id'] = $text; break;
        // 親カテゴリのID
        case '/CategoryResult/Space/Parent': $this->space['Parent'] = $text; break;
        // 最上位カテゴリからの、カテゴリの階層の深さ
        case '/CategoryResult/Space/Depth': $this->space['Depth'] = $text; break;
        // カテゴリ名
        case '/CategoryResult/Space/Title': $this->space['Title'] = $text; break;
        // カテゴリ名の読み
        case '/CategoryResult/Space/JTitle': $this->space['JTitle'] = $text; break;
        // Yahoo! JAPANが提供するYahoo!カテゴリのページURLから、「http://dir.yahoo.co.jp」を除いたもの
        case '/CategoryResult/Space/Path': $this->space['Path'] = $text; break;
        // Yahoo! JAPANが提供するYahoo!カテゴリの、ページの「カテゴリパス（Breadcrumb）」に使用されている文字列
        case '/CategoryResult/Space/JPath': $this->space['JPath'] = $text; break;
        // IDを使ったカテゴリ階層
        case '/CategoryResult/Space/Spath': $this->space['Spath'] = $text; break;
        // サイトが登録された日付もしくは、カテゴリが作成された日付
        case '/CategoryResult/Space/Created': $this->space['Created'] = $text; break;

        // カテゴリItemの件数
        case '/CategoryResult/Category/Count': $this->category_count = $text; break;
        // サイトItemの件数
        case '/CategoryResult/Sites/Count': $this->site_count = $text; break;
        // カテゴリItem
        case '/CategoryResult/Category/Item': $item_i++; break;
        // サイトItem
        case '/CategoryResult/Sites/Item': $site_i++; break;

        // カテゴリタイプ
        case '/CategoryResult/Category/Item/Type': $this->category[$item_i]['Type'] = $text; break;
        case '/CategoryResult/Sites/Item/Type': $this->site[$site_i]['Type'] = $text; break;
        // カテゴリのID
        case '/CategoryResult/Category/Item/Id': $this->category[$item_i]['Id'] = $text; break;
        case '/CategoryResult/Sites/Item/Id': $this->site[$site_i]['Id'] = $text; break;
        // ショートカットカテゴリ自体のID
        case '/CategoryResult/Category/Item/Link': $this->category[$item_i]['Link'] = $text; break;
        case '/CategoryResult/Sites/Item/Link': $this->site[$site_i]['Link'] = $text; break;
        // Yahoo! JAPANで提供するYahoo!カテゴリのページURLから、「http://dir.yahoo.co.jp」を除いたもの
        case '/CategoryResult/Category/Item/Path': $this->category[$item_i]['Path'] = $text; break;
        case '/CategoryResult/Sites/Item/Path': $this->site[$site_i]['Path'] = $text; break;
        // カテゴリ名
        case '/CategoryResult/Category/Item/Title': $this->category[$item_i]['Title'] = $text; break;
        case '/CategoryResult/Sites/Item/Title': $this->site[$site_i]['Title'] = $text; break;
        // カテゴリ名の読み
        case '/CategoryResult/Category/Item/JTitle': $this->category[$item_i]['JTitle'] = $text; break;
        case '/CategoryResult/Sites/Item/JTitle': $this->site[$site_i]['JTitle'] = $text; break;
        // 登録サイトのURL
        case '/CategoryResult/Category/Item/Url': $this->category[$item_i]['Url'] = $text; break;
        case '/CategoryResult/Sites/Item/Url': $this->site[$site_i]['Url'] = $text; break;
        // 登録サイトへのリンク用（クリック用）URL
        case '/CategoryResult/Category/Item/ClickUrl': $this->category[$item_i]['ClickUrl'] = $text; break;
        case '/CategoryResult/Sites/Item/ClickUrl': $this->site[$site_i]['ClickUrl'] = $text; break;
        // 登録サイトの説明
        case '/CategoryResult/Category/Item/Summary': $this->category[$item_i]['Summary'] = $text; break;
        case '/CategoryResult/Sites/Item/Summary': $this->site[$site_i]['Summary'] = $text; break;
        // サイトが登録された日付もしくは、カテゴリが作成された日付
        case '/CategoryResult/Category/Item/Created': $this->category[$item_i]['Created'] = $text; break;
        case '/CategoryResult/Sites/Item/Created': $this->site[$site_i]['Created'] = $text; break;
        // 過去1週間以内に新しく登録されたサイトの場合「1」、それ以外の場合「0」
        case '/CategoryResult/Category/Item/New': $this->category[$item_i]['New'] = $text; break;
        case '/CategoryResult/Sites/Item/New': $this->site[$site_i]['New'] = $text; break;
        // Yahoo!カテゴリ独自の基準によって、優れた内容であると評価されたサイトの場合「1」、それ以外の場合は「0」
        case '/CategoryResult/Category/Item/Cool': $this->category[$item_i]['Cool'] = $text; break;
        case '/CategoryResult/Sites/Item/Cool': $this->site[$site_i]['Cool'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * レスポンスの状態やサーバーからのメッセージを取得
     *
     * @access public
     * @param string キー
     * @return mixed レスポンスの状態やサーバーからのメッセージ
     */
    function getStatus($name=null)
    {
        if ($name !== null) {
            return isset($this->status[$name]) ? $this->status[$name] : null;
        } else {
            return $this->status;
        }
    }

    /**
     * カテゴリに関する情報を取得する
     *
     * @access public
     * @param string キー
     * @return mixed カテゴリに関する情報
     */
    function getSpace($name=null)
    {
        if ($name !== null) {
            return isset($this->space[$name]) ? $this->space[$name] : null;
        } else {
            return $this->space;
        }
    }

    /**
     * カテゴリ数を取得
     *
     * @access public
     * @return int カテゴリ数
     */
    function getCategoryCount()
    {
        return $this->category_count;
    }

    /**
     * カテゴリデータを取得する
     *
     * @access public
     * @return array カテゴリデータ配列
     */
    function getCategory()
    {
        return $this->category;
    }

    /**
     * サイト数を取得
     *
     * @access public
     * @return int サイト数
     */
    function getSiteCount()
    {
        return $this->site_count;
    }

    /**
     * サイトデータを取得する
     *
     * @access public
     * @return array サイトデータ配列
     */
    function getSite()
    {
        return $this->site;
    }
}
