<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpJIMServiceRequest.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - かな漢字変換Webサービス）
 */
require_once 'SyL_WebServiceJlpJIMServiceResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - かな漢字変換Webサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * かな漢字変換Webサービス
 *   http://developer.yahoo.co.jp/jlp/JIMService/V1/conversion.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpJIMServiceRequest.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceJlpJIMServiceRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'jlp.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/JIMService/V1/conversion';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceJlpJIMServiceResponse';

    /**
     * 解析対象のテキストをセットする
     *
     * @access public
     * @param string 解析対象のテキスト
     */
    function setSentence($sentence)
    {
        parent::set('sentence', $sentence);
    }

    /**
     * sentenceのテキストフォーマットをセットする
     *
     * @access public
     * @param string sentenceのテキストフォーマット
     */
    function setFormat($format)
    {
        switch ($format) {
        case 'roman':
            break;
        default:
            trigger_error("[SyL error] Invalid `format' property ({$format}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
        parent::set('format', $format);
    }

    /**
     * かな漢字変換処理で通常変換、ローマ字変換、推測変換のいづれかをセットする
     *
     * @access public
     * @param string かな漢字変換処理で通常変換、ローマ字変換、推測変換のいづれか
     */
    function setMode($mode)
    {
        switch ($mode) {
        case 'normal':
        case 'roman':
        case 'predictive':
            break;
        default:
            trigger_error("[SyL error] Invalid `mode' property ({$mode}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
        parent::set('mode', $mode);
    }

    /**
     * 通常のかな漢字変換のほかに、指定の変換候補の返却値をセットする
     *
     * @access public
     * @param string 通常のかな漢字変換のほかに、指定の変換候補の返却値
     */
    function setResponse($response)
    {
        foreach (array_map('trim', explode(',', $response)) as $tmp) {
            switch ($tmp) {
            case 'katakana':
            case 'hiragana':
            case 'alphanumeric':
            case 'half_katakana':
            case 'half_alphanumeric':
                break;
            default:
                trigger_error("[SyL error] Invalid `response' property ({$response}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('response', $response);
    }

    /**
     * 変換候補用の辞書をセットする
     *
     * @access public
     * @param string 変換候補用の辞書
     */
    function setDictionary($dictionary)
    {
        foreach (array_map('trim', explode(',', $dictionary)) as $tmp) {
            switch ($tmp) {
            case 'default':
            case 'name':
            case 'place':
            case 'zip':
            case 'symbol':
                break;
            default:
                trigger_error("[SyL error] Invalid `dictionary' property ({$dictionary}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('dictionary', $dictionary);
    }

    /**
     * 文節単位の変換候補の数をセットする
     *
     * @access public
     * @param int 文節単位の変換候補の数
     */
    function setResults($results)
    {
        if (preg_match('/^\d+$/', $results) && (($results >= 1) && ($results <= 999))) {
            parent::set('results', $results);
        } else {
            trigger_error("[SyL error] Invalid `results' property ({$results}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
