<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertDetailRequest.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan -みんなの検定 検定詳細Webサービス）
 */
require_once 'SyL_WebServiceMinnaCertCertDetailResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - みんなの検定 検定リストWebサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * みんなの検定 検定詳細Webサービス
 *   http://developer.yahoo.co.jp/minna_cert/certdetail/V1/certdetail.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertDetailRequest.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMinnaCertCertDetailRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'cert.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/MinnaCertWebService/V1/certDetail';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceMinnaCertCertDetailResponse';

    /**
     * 検定IDをセットする
     *
     * @access public
     * @param int 検定ID
     */
    function setCert_id($cert_id)
    {
        if (preg_match('/^\d+$/', $cert_id)) {
            parent::set('cert_id', $cert_id);
        } else {
            trigger_error("[SyL error] Invalid `cert_id' property ({$cert_id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 問題情報取得フラグをセットする
     *
     * @access public
     * @param int 問題情報取得フラグ
     */
    function setGet_q($get_q)
    {
        switch ((string)$get_q) {
        case '0': // 問題情報を取得しない
        case '1': // 問題情報を取得する
        case '2': // 問題情報+正解と解説を取得する
            parent::set('get_q', $get_q);
            break;
        default:
            trigger_error("[SyL error] Invalid `get_q' property ({$get_q}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 問題取得番号をセットする
     *
     * @access public
     * @param int 問題取得番号
     */
    function setOrder_number($order_number)
    {
        switch ((string)$order_number) {
        case '0': // すべての問題情報を取得する
        case '1': // 以下、対応する問題番号の情報を取得する
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case '10':
            parent::set('order_number', $order_number);
            break;
        default:
            trigger_error("[SyL error] Invalid `order_number' property ({$order_number}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
