<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMusicStationResponse.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - サウンドステーション番組リスト用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * サウンドステーション番組リスト
 *   http://developer.yahoo.co.jp/music/station/v1/programlist.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMusicStationResponse.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMusicStationResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 番組件数
     *
     * @access private
     * @var int
     */
     var $count = 0;
    /**
     * 番組に関する情報
     *
     * @access private
     * @var array
     */
    var $items = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $item_i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 番組件数
        case '/ProgramResult/Program/Count': $this->count = $text; break;

        // 番組に関する情報
        case '/ProgramResult/Program/Item':  $item_i++; break;
        // チャンネルカテゴリ
        case '/ProgramResult/Program/Item/Category': $this->items[$item_i]['Category'] = $text; break;
        // チャンネル名
        case '/ProgramResult/Program/Item/ChannelName': $this->items[$item_i]['ChannelName'] = $text; break;
        // 番組名
        case '/ProgramResult/Program/Item/ProgramName': $this->items[$item_i]['ProgramName'] = $text; break;
        // チャンネルページURL
        case '/ProgramResult/Program/Item/ChannelURL': $this->items[$item_i]['ChannelURL'] = $text; break;
        // 番組プレーヤー起動用URL
        case '/ProgramResult/Program/Item/ProgramURL': $this->items[$item_i]['ProgramURL'] = $text; break;
        // レコメンドチャンネル以下の番組の場合「最終更新日(YYYYMMDD形式)」
        case '/ProgramResult/Program/Item/ProgramLastUpdate': $this->items[$item_i]['ProgramLastUpdate'] = $text; break;
        // 期間限定番組の場合「公開終了日(YYYYMMDD形式)」
        case '/ProgramResult/Program/Item/ProgramEnd': $this->items[$item_i]['ProgramEnd'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 番組件数を取得
     *
     * @access public
     * @return int 番組件数
     */
    function getCount()
    {
        return $this->count;
    }

    /**
     * 番組に関する情報を取得する
     *
     * @access public
     * @return array 番組に関する情報
     */
    function getItems()
    {
        return $this->items;
    }
}
