<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceNewsTopicsResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - ニュース - トピックスAPI）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * ニュース - トピックスAPI
 *   http://developer.yahoo.co.jp/news/topics/V1/topics.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceNewsTopicsResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceNewsTopicsResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 検索条件に一致した総数
     *
     * @access private
     * @var int 
     */
     var $total_results_returned = 0;
    /**
     * 検索結果データ配列
     *
     * @access private
     * @var array
     */
    var $results = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            break;
        case '/ResultSet/Result':
            $i++;
            break;
        // 最後にトピックを更新した日時
        case '/ResultSet/Result/datetime': $this->results[$i]['datetime'] = $text; break;
        // 15文字程度の見出し
        case '/ResultSet/Result/title': $this->results[$i]['title'] = $text; break;
        // トピックに関連するキーワード
        case '/ResultSet/Result/keyword': $this->results[$i]['keyword'] = array(); break;
        case '/ResultSet/Result/keyword/word': $this->results[$i]['keyword'][] = $text; break;
        // 常設トピック名
        case '/ResultSet/Result/topicname': $this->results[$i]['topicname'] = $text; break;
        // カテゴリ
        case '/ResultSet/Result/category': $this->results[$i]['category'] = $text; break;
        // サブカテゴリ
        case '/ResultSet/Result/subcategory': $this->results[$i]['subcategory'] = $text; break;
        // url
        case '/ResultSet/Result/url': $this->results[$i]['url'] = $text; break;
        // Yahoo! JAPANトップページへの掲載有無
        case '/ResultSet/Result/topflg': $this->results[$i]['topflg'] = $text; break;
        // PV指標
        case '/ResultSet/Result/pvindex': $this->results[$i]['pvindex'] = $text; break;
        // トピックに関連するトピック
        case '/ResultSet/Result/relatedtopics': $this->results[$i]['relatedtopics'] = array(); break;
        // トピックに関連するトピック - 関連トピック名
        case '/ResultSet/Result/relatedtopics/title': $this->results[$i]['relatedtopics']['title'][] = array(); break;
        // トピックに関連するトピック - 関連トピックURL
        case '/ResultSet/Result/relatedtopics/url': $this->results[$i]['relatedtopics']['url'][] = array(); break;
        // トピックに関連するサイト
        case '/ResultSet/Result/relatedsite': $this->results[$i]['relatedsite'] = array(); break;
        // トピックに関連するサイト - 関連トピック名
        case '/ResultSet/Result/relatedsite/title': $this->results[$i]['relatedsite']['title'][] = array(); break;
        // トピックに関連するサイト - 関連トピックURL
        case '/ResultSet/Result/relatedsite/url': $this->results[$i]['relatedsite']['url'][] = array(); break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 検索総数を取得する
     *
     * @access public
     * @return int 検索総数
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * 検索結果データを取得する
     *
     * @access public
     * @return array 検索結果データ配列
     */
    function getResults()
    {
        return $this->results;
    }
}
