<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchImageRequest.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - 画像検索用）
 */
require_once 'SyL_WebServiceSearchImageResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - 画像検索用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * 画像検索
 *   http://developer.yahoo.co.jp/search/image/V1/imageSearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchImageRequest.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceSearchImageRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'search.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/ImageSearchService/V1/imageSearch';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceSearchImageResponse';

    /**
     * 検索クエリーをセットする
     *
     * @access public
     * @param string 検索クエリー
     */
    function setQuery($query)
    {
        parent::set('query', $query);
    }

    /**
     * 指定検索の種類をセットする
     * (all, any, phrase)
     *
     * @access public
     * @param string 指定検索の種類
     */
    function setType($type)
    {
        switch ($type) {
        case 'all':
        case 'any':
        case 'phrase':
            parent::set('type', $type);
            break;
        default:
            trigger_error("[SyL error] Invalid `type' property ($type) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 返却結果の数をセットする
     *
     * @access public
     * @param int 返却結果の数
     */
    function setResults($results)
    {
        if (preg_match('/^\d+$/', $results) && (($results >= 0) && ($results <= 50))) {
            parent::set('results', $results);
        } else {
            trigger_error("[SyL error] Invalid `results' property ($results) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 返却結果の先頭位置をセットする
     *
     * @access public
     * @param int 返却結果の先頭位置
     */
    function setStart($start)
    {
        if (preg_match('/^\d+$/', $start)) {
            $results = isset($this->parameters['results']) ? $this->parameters['results'] : 10;
            if (($start + $results - 1) <= 1000) {
                parent::set('start', $start);
            } else {
                trigger_error("[SyL error] Invalid `start' property ($start) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        } else {
            trigger_error("[SyL error] Invalid `start' property ($start) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 検索するファイルの種類をセットする
     *
     * @access public
     * @param string 検索するファイルの種類
     */
    function setFormat($format)
    {
        switch ($format) {
        case 'any':
        case 'bmp':
        case 'gif':
        case 'jpeg':
        case 'png':
            parent::set('type', $type);
            break;
        default:
            trigger_error("[SyL error] Invalid `format' property ($format) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * アダルトコンテンツの検索結果を含めるかどうかをセットする
     *
     * @access public
     * @param int アダルトコンテンツの検索結果を含めるかどうか
     */
    function setAdult_ok($adult_ok)
    {
        $adult_ok = ($adult_ok) ? '1' : '';
        parent::set('adult_ok', $adult_ok);
    }

    /**
     * カラー画像だけを検索結果とするかどうかを指定する
     *
     * @access public
     * @param string カラー画像だけを検索結果とするかどうかを指定
     */
    function setColoration($coloration)
    {
        switch ($coloration) {
        case 'any':
        case 'color':
        case 'bw':
            parent::set('coloration', $coloration);
            break;
        default:
            trigger_error("[SyL error] Invalid `coloration' property ($coloration) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 検索ドメインをセットする
     *
     * @access public
     * @param string or array 検索ドメイン
     */
    function setSite($site)
    {
        parent::set('site', $site);
    }
}
