<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchWebunitRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - 関連検索用）
 */
require_once 'SyL_WebServiceSearchWebunitResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - 関連検索用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * 関連検索
 *   http://developer.yahoo.co.jp/search/webunit/V1/webunitSearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchWebunitRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceSearchWebunitRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'search.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/AssistSearchService/V1/webunitSearch';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceSearchWebunitResponse';

    /**
     * 検索クエリーをセットする
     *
     * @access public
     * @param string 検索クエリー
     */
    function setQuery($query)
    {
        parent::set('query', $query);
    }

    /**
     * 返却結果の数をセットする
     *
     * @access public
     * @param int 返却結果の数
     */
    function setResults($results)
    {
        if (preg_match('/^\d+$/', $results) && (($results >= 0) && ($results <= 100))) {
            parent::set('results', $results);
        } else {
            trigger_error("[SyL error] Invalid `results' property ($results) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 返却結果の先頭位置をセットする
     *
     * @access public
     * @param int 返却結果の先頭位置
     */
    function setStart($start)
    {
        if (preg_match('/^\d+$/', $start)) {
            $results = isset($this->parameters['results']) ? $this->parameters['results'] : 10;
            if (($start + $results - 1) <= 100) {
                parent::set('start', $start);
            } else {
                trigger_error("[SyL error] Invalid `start' property ($start) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        } else {
            trigger_error("[SyL error] Invalid `start' property ($start) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
