<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingItemsearchRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - 商品検索用）
 */
require_once 'SyL_WebServiceShoppingItemsearchResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - 商品検索用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * 商品検索
 *   http://developer.yahoo.co.jp/shopping/itemsearch/V1/itemSearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingItemsearchRequest.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceShoppingItemsearchRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'shopping.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/ShoppingWebService/V1/itemSearch';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceShoppingItemsearchResponse';

    /**
     * Yahoo! JAPANアフィリエイト(yid)とバリューコマースアフィリエイト(vc)をセットする
     *
     * @access public
     * @param string Yahoo! JAPANアフィリエイト(yid)、またはバリューコマースアフィリエイト(vc)
     */
    function setAffiliateType($affiliate_type)
    {
        switch ($type) {
        case 'yid':
        case 'vc':
            parent::set('affiliate_type', $affiliate_type);
            break;
        default:
            trigger_error("[SyL error] Invalid `affiliate_type' property ({$affiliate_type}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Yahoo! JAPANアフィリエイトIDもしくは、バリューコマースアフィリエイトIDをセットする
     *
     * @access public
     * @param string Yahoo! JAPANアフィリエイトIDもしくは、バリューコマースアフィリエイトID
     */
    function setAffiliateId($affiliate_id)
    {
        parent::set('affiliate_id', $affiliate_id);
    }

    /**
     * JSONPとして出力する際のコールバック関数名をセットする
     *
     * @access public
     * @param string JSONPとして出力する際のコールバック関数名
     */
    function setCallback($callback)
    {
        parent::set('callback', $callback);
    }

    /**
     * 検索クエリーをセットする
     *
     * @access public
     * @param string 検索クエリー
     */
    function setQuery($query)
    {
        parent::set('query', $query);
    }

    /**
     * 指定検索の種類をセットする
     * (all, any, phrase)
     *
     * @access public
     * @param string 指定検索の種類
     */
    function setType($type)
    {
        switch ($type) {
        case 'all':
        case 'any':
            parent::set('type', $type);
            break;
        default:
            trigger_error("[SyL error] Invalid `type' property ({$type}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * JANコードをセットする
     *
     * @access public
     * @param int JANコード
     */
    function setJan($jan)
    {
        if (preg_match('/^\d+$/', $jan)) {
            parent::set('jan', $jan);
        } else {
            trigger_error("[SyL error] Invalid `jan' property ({$jan}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ISBNコード(書籍コード)をセットする
     *
     * @access public
     * @param int ISBNコード(書籍コード)
     */
    function setIsbn($isbn)
    {
        if (preg_match('/^\d+$/', $isbn)) {
            parent::set('isbn', $isbn);
        } else {
            trigger_error("[SyL error] Invalid `isbn' property ({$isbn}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * カテゴリIDをセットする
     *
     * @access public
     * @param int カテゴリID
     */
    function setCategoryId($category_id)
    {
        if (preg_match('/^\d+$/', $category_id)) {
            parent::set('category_id', $category_id);
        } else {
            trigger_error("[SyL error] Invalid `category_id' property ({$category_id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 製品IDをセットする
     *
     * @access public
     * @param int 製品ID
     */
    function setProductId($product_id)
    {
        if (preg_match('/^\d+$/', $product_id)) {
            parent::set('product_id', $product_id);
        } else {
            trigger_error("[SyL error] Invalid `product_id' property ({$product_id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 人物IDをセットする
     *
     * @access public
     * @param int 人物ID
     */
    function setPersonId($person_id)
    {
        if (preg_match('/^\d+$/', $person_id)) {
            parent::set('person_id', $person_id);
        } else {
            trigger_error("[SyL error] Invalid `person_id' property ({$person_id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ブランドIDをセットする
     *
     * @access public
     * @param int ブランドID
     */
    function setBrandId($brand_id)
    {
        if (preg_match('/^\d+$/', $brand_id)) {
            parent::set('brand_id', $brand_id);
        } else {
            trigger_error("[SyL error] Invalid `brand_id' property ({$brand_id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ストアのIDをセットする
     *
     * @access public
     * @param string ストアのID
     */
    function setStoreId($store_id)
    {
        parent::set('store_id', $store_id);
    }

    /**
     * 価格指定(最低価格)した価格以上をセットする
     *
     * @access public
     * @param int 価格指定(最低価格)した価格以上
     */
    function setPriceFrom($price_from)
    {
        if (preg_match('/^\d+$/', $price_from)) {
            parent::set('price_from', $price_from);
        } else {
            trigger_error("[SyL error] Invalid `price_from' property ({$price_from}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 価格指定(最高価格)した価格未満をセットする
     *
     * @access public
     * @param int 価格指定(最高価格)した価格未満
     */
    function setPriceTo($price_to)
    {
        if (preg_match('/^\d+$/', $price_to)) {
            parent::set('price_to', $price_to);
        } else {
            trigger_error("[SyL error] Invalid `price_to' property ({$price_to}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 取得する検索結果数をセットする
     *
     * @access public
     * @param int 取得する検索結果数
     */
    function setHits($hits)
    {
        if (preg_match('/^\d+$/', $hits) && (($hits >= 0) && ($hits <= 50))) {
            parent::set('hits', $hits);
        } else {
            trigger_error("[SyL error] Invalid `hits' property ({$hits}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 何件目から表示させるかをセットする
     *
     * @access public
     * @param int 何件目から表示させるか
     */
    function setOffset($offset)
    {
        if (preg_match('/^\d+$/', $offset)) {
            parent::set('offset', $offset);
        } else {
            trigger_error("[SyL error] Invalid `offset' property ({$offset}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 検索するファイルの種類をセットする
     *
     * @access public
     * @param string 検索するファイルの種類
     */
    function setSort($sort)
    {
        switch ($sort) {
        case 'price': // 商品価格
        case 'name':  // ストア名
        case 'score': // おすすめ順
        case 'sold':  // 売れ筋順
            parent::set('sort', $sort);
            break;
        default:
            trigger_error("[SyL error] Invalid `sort' property ({$sort}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 価格幅、サブカテゴリとサブカテゴリに含まれる商品数のリストの取得をセットする
     *
     * @access public
     * @param string 価格幅、サブカテゴリとサブカテゴリに含まれる商品数のリストの取得
     */
    function setModule($module)
    {
        switch ($module) {
        case 'priceranges':
        case 'subcategories':
            parent::set('module', $module);
            break;
        default:
            trigger_error("[SyL error] Invalid `module' property ({$module}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 在庫絞り込みをセットする
     *
     * @access public
     * @param int 在庫絞り込み
     */
    function setAvailability($availability)
    {
        if ($availability == '1') {
            parent::set('availability', $availability);
        } else {
            trigger_error("[SyL error] Invalid `availability' property ({$availability}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * セール中商品絞り込みをセットする
     *
     * @access public
     * @param int セール中商品絞り込み
     */
    function setDiscount($discount)
    {
        if ($discount == '1') {
            parent::set('discount', $discount);
        } else {
            trigger_error("[SyL error] Invalid `discount' property ({$discount}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 送料無料をセットする
     *
     * @access public
     * @param int 送料無料
     */
    function setShipping($shipping)
    {
        if ($shipping == '1') {
            parent::set('shipping', $shipping);
        } else {
            trigger_error("[SyL error] Invalid `shipping' property ({$shipping}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

}
